/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.HydraBreathEntity;
import com.iafenvoy.iceandfire.entity.HydraHeadEntity;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3855;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8103;

public class HydraEntity
extends class_1588
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes {
    public static final int HEADS = 9;
    public static final double HEAD_HEALTH_THRESHOLD = 20.0;
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(HydraEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HEAD_COUNT = class_2945.method_12791(HydraEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SEVERED_HEAD = class_2945.method_12791(HydraEntity.class, (class_2941)class_2943.field_13327);
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    public final boolean[] isStriking = new boolean[9];
    public final float[] strikingProgress = new float[9];
    public final float[] prevStrikeProgress = new float[9];
    public final boolean[] isBreathing = new boolean[9];
    public final float[] speakingProgress = new float[9];
    public final float[] prevSpeakingProgress = new float[9];
    public final float[] breathProgress = new float[9];
    public final float[] prevBreathProgress = new float[9];
    public final int[] breathTicks = new int[9];
    public final float[] headDamageTracker = new float[9];
    private final float headDamageThreshold;
    private int animationTick;
    private Animation currentAnimation;
    private HydraHeadEntity[] headBoxes = new HydraHeadEntity[81];
    private int strikeCooldown = 0;
    private int breathCooldown = 0;
    private int lastHitHead = 0;
    private int prevHeadCount = -1;
    private int regrowHeadCooldown = 0;
    private boolean onlyRegrowOneHeadNotTwo = false;
    private boolean multipartLoaded = false;

    public HydraEntity(class_1299<HydraEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.headDamageThreshold = Math.max(5.0f, ((Double)IafCommonConfig.INSTANCE.hydra.maxHealth.getValue()).floatValue() * 0.08f);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.hydra.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23724, 1.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.hydra.maxHealth.getValue()).doubleValue());
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, entity -> {
            BlacklistedFromStatues blacklisted;
            return DragonUtils.isAlive(entity) && !(entity instanceof class_1569) || entity instanceof BlacklistedFromStatues && (blacklisted = (BlacklistedFromStatues)entity).canBeTurnedToStone();
        }));
    }

    public boolean method_6121(class_1297 entityIn) {
        return false;
    }

    public void method_6007() {
        int index;
        super.method_6007();
        class_1309 attackTarget = this.method_5968();
        if (attackTarget != null && this.method_6057((class_1297)attackTarget) && !this.isBreathing[index = this.field_5974.method_43048(this.getHeadCount())] && !this.isStriking[index]) {
            if (this.method_5739((class_1297)attackTarget) < 6.0f) {
                if (this.strikeCooldown == 0 && this.strikingProgress[index] == 0.0f) {
                    this.isBreathing[index] = false;
                    this.isStriking[index] = true;
                    this.method_37908().method_8421((class_1297)this, (byte)(40 + index));
                    this.strikeCooldown = 3;
                }
            } else if (this.field_5974.method_43056() && this.breathCooldown == 0) {
                this.isBreathing[index] = true;
                this.isStriking[index] = false;
                this.method_37908().method_8421((class_1297)this, (byte)(50 + index));
                this.breathCooldown = 15;
            }
        }
        for (int i = 0; i < 9; ++i) {
            boolean striking = this.isStriking[i];
            boolean breathing = this.isBreathing[i];
            this.prevStrikeProgress[i] = this.strikingProgress[i];
            if (striking && this.strikingProgress[i] > 9.0f) {
                this.isStriking[i] = false;
                if (attackTarget != null && this.method_5739((class_1297)attackTarget) < 6.0f) {
                    attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
                    attackTarget.method_6092(new class_1293(class_1294.field_5899, 100, 3, false, false));
                    attackTarget.method_6005(0.25, this.method_23317() - attackTarget.method_23317(), this.method_23321() - attackTarget.method_23321());
                }
            }
            if (breathing) {
                if (this.field_6012 % 7 == 0 && attackTarget != null && i < this.getHeadCount()) {
                    class_243 Vector3d = this.method_5828(1.0f);
                    if (this.field_5974.method_43057() < 0.2f) {
                        this.method_5783((class_3414)IafSounds.HYDRA_SPIT.get(), this.method_6107(), this.method_6017());
                    }
                    double headPosX = this.headBoxes[i].method_23317() + Vector3d.field_1352;
                    double headPosY = this.headBoxes[i].method_23318() + (double)1.3f;
                    double headPosZ = this.headBoxes[i].method_23321() + Vector3d.field_1350;
                    double d2 = attackTarget.method_23317() - headPosX + this.field_5974.method_43059() * 0.4;
                    double d3 = attackTarget.method_23318() + (double)attackTarget.method_5751() - headPosY + this.field_5974.method_43059() * 0.4;
                    double d4 = attackTarget.method_23321() - headPosZ + this.field_5974.method_43059() * 0.4;
                    HydraBreathEntity entitylargefireball = new HydraBreathEntity((class_1299<? extends class_3855>)((class_1299)IafEntities.HYDRA_BREATH.get()), this.method_37908(), this, d2, d3, d4);
                    entitylargefireball.method_5814(headPosX, headPosY, headPosZ);
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)entitylargefireball);
                    }
                }
                if (!(!this.isBreathing[i] || attackTarget != null && attackTarget.method_5805() && this.breathTicks[i] <= 60 || this.method_37908().field_9236)) {
                    this.isBreathing[i] = false;
                    this.breathTicks[i] = 0;
                    this.breathCooldown = 15;
                    this.method_37908().method_8421((class_1297)this, (byte)(70 + i));
                }
                int n = i;
                this.breathTicks[n] = this.breathTicks[n] + 1;
            } else {
                this.breathTicks[i] = 0;
            }
            if (striking && this.strikingProgress[i] < 10.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] + 2.5f;
            } else if (!striking && this.strikingProgress[i] > 0.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] - 2.5f;
            }
            this.prevSpeakingProgress[i] = this.speakingProgress[i];
            if (this.speakingProgress[i] > 0.0f) {
                int n = i;
                this.speakingProgress[n] = this.speakingProgress[n] - 0.1f;
            }
            this.prevBreathProgress[i] = this.breathProgress[i];
            if (breathing && this.breathProgress[i] < 10.0f) {
                int n = i;
                this.breathProgress[n] = this.breathProgress[n] + 1.0f;
                continue;
            }
            if (breathing || !(this.breathProgress[i] > 0.0f)) continue;
            int n = i;
            this.breathProgress[n] = this.breathProgress[n] - 1.0f;
        }
        if (this.strikeCooldown > 0) {
            --this.strikeCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.getHeadCount() == 1 && this.getSeveredHead() != -1) {
            this.setSeveredHead(-1);
        }
        if (this.getHeadCount() == 1 && !this.method_5809()) {
            this.setHeadCount(2);
            this.setSeveredHead(1);
            this.onlyRegrowOneHeadNotTwo = true;
        }
        if (this.getSeveredHead() != -1 && this.getSeveredHead() < this.getHeadCount()) {
            this.setSeveredHead(class_3532.method_15340((int)this.getSeveredHead(), (int)0, (int)(this.getHeadCount() - 1)));
            ++this.regrowHeadCooldown;
            if (this.regrowHeadCooldown >= 100) {
                this.headDamageTracker[this.getSeveredHead()] = 0.0f;
                this.setSeveredHead(-1);
                if (this.method_5809()) {
                    this.setHeadCount(this.getHeadCount() - 1);
                } else {
                    this.method_5783((class_3414)IafSounds.HYDRA_REGEN_HEAD.get(), this.method_6107(), this.method_6017());
                    if (!this.onlyRegrowOneHeadNotTwo) {
                        this.setHeadCount(this.getHeadCount() + 1);
                    }
                }
                this.onlyRegrowOneHeadNotTwo = false;
                this.regrowHeadCooldown = 0;
            }
        } else {
            this.regrowHeadCooldown = 0;
        }
    }

    public void resetParts() {
        this.clearParts();
        this.headBoxes = new HydraHeadEntity[18];
        for (int i = 0; i < this.getHeadCount(); ++i) {
            this.headBoxes[i] = new HydraHeadEntity(this, 3.2f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 1.75f, 1.0f, i, false);
            this.headBoxes[9 + i] = new HydraHeadEntity(this, 2.1f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 0.75f, 1.0f, i, true);
            this.headBoxes[i].method_5719((class_1297)this);
            this.headBoxes[9 + i].method_5719((class_1297)this);
            this.headBoxes[i].setParent((class_1297)this);
            this.headBoxes[9 + i].setParent((class_1297)this);
            this.method_37908().method_8649((class_1297)this.headBoxes[i]);
            this.method_37908().method_8649((class_1297)this.headBoxes[9 + i]);
        }
        this.multipartLoaded = true;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.multipartLoaded || this.prevHeadCount != this.getHeadCount()) {
            this.resetParts();
        }
        float partY = 1.0f - this.field_42108.method_48566() * 0.5f;
        for (int i = 0; i < this.getHeadCount(); ++i) {
            this.headBoxes[i].method_5814(this.headBoxes[i].method_23317(), this.method_23318() + (double)partY, this.headBoxes[i].method_23321());
            IafEntityUtil.updatePart(this.headBoxes[i], (class_1309)this);
            this.headBoxes[9 + i].method_5814(this.headBoxes[9 + i].method_23317(), this.method_23318() + (double)partY, this.headBoxes[9 + i].method_23321());
            IafEntityUtil.updatePart(this.headBoxes[10], (class_1309)this);
        }
        if (this.getHeadCount() > 1 && !this.method_5809() && this.method_6032() < this.method_6063() && this.field_6012 % 30 == 0) {
            int level = this.getHeadCount() - 1;
            if (this.getSeveredHead() != -1) {
                --level;
            }
            this.method_6092(new class_1293(class_1294.field_5924, 30, level, false, false));
        }
        if (this.method_5809()) {
            this.method_6016(class_1294.field_5924);
        }
        this.prevHeadCount = this.getHeadCount();
    }

    private void clearParts() {
        for (HydraHeadEntity entity : this.headBoxes) {
            if (entity == null) continue;
            entity.method_5650(class_1297.class_5529.field_26999);
        }
        this.multipartLoaded = false;
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.clearParts();
        super.method_5650(reason);
    }

    protected void method_6013(class_1282 source) {
        this.speakingProgress[this.field_5974.method_43048((int)this.getHeadCount())] = 1.0f;
        super.method_6013(source);
    }

    public void method_5966() {
        this.speakingProgress[this.field_5974.method_43048((int)this.getHeadCount())] = 1.0f;
        super.method_5966();
    }

    public int method_5970() {
        return 100 / this.getHeadCount();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant());
        compound.method_10569("HeadCount", this.getHeadCount());
        compound.method_10569("SeveredHead", this.getSeveredHead());
        for (int i = 0; i < 9; ++i) {
            compound.method_10548("HeadDamage" + i, this.headDamageTracker[i]);
        }
        this.clearParts();
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(compound.method_10550("Variant"));
        this.setHeadCount(compound.method_10550("HeadCount"));
        this.setSeveredHead(compound.method_10550("SeveredHead"));
        for (int i = 0; i < 9; ++i) {
            this.headDamageTracker[i] = compound.method_10583("HeadDamage" + i);
        }
        this.setConfigurableAttributes();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(HEAD_COUNT, (Object)3);
        builder.method_56912(SEVERED_HEAD, (Object)-1);
    }

    public boolean method_5643(class_1282 source, float amount) {
        int headIndex;
        if (this.lastHitHead > this.getHeadCount()) {
            this.lastHitHead = this.getHeadCount() - 1;
        }
        int n = headIndex = this.lastHitHead;
        this.headDamageTracker[n] = this.headDamageTracker[n] + amount;
        if (this.headDamageTracker[headIndex] > this.headDamageThreshold && (this.getSeveredHead() == -1 || this.getSeveredHead() >= this.getHeadCount())) {
            this.headDamageTracker[headIndex] = 0.0f;
            this.regrowHeadCooldown = 0;
            this.setSeveredHead(headIndex);
            this.method_5783(class_3417.field_14584, this.method_6107(), this.method_6017());
        }
        if (this.method_6032() <= amount + 5.0f && this.getHeadCount() > 1 && !source.method_48789(class_8103.field_42242)) {
            amount = 0.0f;
        }
        return super.method_5643(source, amount);
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        class_1315 data = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
        this.setVariant(this.field_5974.method_43048(3));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    @Override
    public boolean shouldAnimalsFear(class_1297 entity) {
        return true;
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public int getHeadCount() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(HEAD_COUNT)), (int)1, (int)9);
    }

    public void setHeadCount(int count) {
        this.field_6011.method_12778(HEAD_COUNT, (Object)class_3532.method_15340((int)count, (int)1, (int)9));
    }

    public int getSeveredHead() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(SEVERED_HEAD)), (int)-1, (int)9);
    }

    public void setSeveredHead(int count) {
        this.field_6011.method_12778(SEVERED_HEAD, (Object)class_3532.method_15340((int)count, (int)-1, (int)9));
    }

    public void method_5711(byte id) {
        if (id >= 40 && id <= 48) {
            int index = id - 40;
            this.isStriking[class_3532.method_15340((int)index, (int)0, (int)8)] = true;
        } else if (id >= 50 && id <= 58) {
            int index = id - 50;
            this.isBreathing[class_3532.method_15340((int)index, (int)0, (int)8)] = true;
        } else if (id >= 70 && id <= 78) {
            int index = id - 70;
            this.isBreathing[class_3532.method_15340((int)index, (int)0, (int)8)] = false;
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_6049(class_1293 potioneffectIn) {
        return potioneffectIn.method_5579() != class_1294.field_5899 && super.method_6049(potioneffectIn);
    }

    public void onHitHead(float damage, int headIndex) {
        this.lastHitHead = headIndex;
    }

    public void triggerHeadFlags(int index) {
        this.lastHitHead = index;
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.HYDRA_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)IafSounds.HYDRA_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.HYDRA_DIE.get();
    }
}

