/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.DreadQueenEntity;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.registry.IafSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class IafDragonLogic {
    private final DragonBaseEntity dragon;
    long ticksAfterClearingTarget;

    public IafDragonLogic(DragonBaseEntity dragon) {
        this.dragon = dragon;
    }

    public void updateDragonServer() {
        this.dragon.updateRider();
        this.dragon.updatePitch(this.dragon.field_6036 - this.dragon.method_23318());
        if (this.dragon.lookingForRoostAIFlag && this.dragon.method_6065() != null || this.dragon.method_6113()) {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.sleep.getValue()).booleanValue() && !this.dragon.method_6113() && !this.dragon.isTimeToWake() && this.dragon.method_5685().isEmpty() && this.dragon.getCommand() != 2) {
            if (this.dragon.hasHomePosition && this.dragon.method_18412() != null && DragonUtils.isInHomeDimension(this.dragon) && this.dragon.getDistanceSquared(class_243.method_24953((class_2382)this.dragon.method_18412())) > this.dragon.method_17681() * 10.0f && this.dragon.getCommand() != 2 && this.dragon.getCommand() != 1) {
                this.dragon.lookingForRoostAIFlag = true;
            } else {
                this.dragon.lookingForRoostAIFlag = false;
                if (this.dragon.method_37908().method_8510() - this.ticksAfterClearingTarget >= 20L && !this.dragon.method_5799() && this.dragon.method_24828() && !this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.method_5968() == null) {
                    this.dragon.method_6179(true);
                }
            }
        } else {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (this.dragon.method_6113() && (this.dragon.isFlying() || this.dragon.isHovering() || this.dragon.method_5799() || this.dragon.method_37908().method_22348(this.dragon.method_24515()) && this.dragon.isTimeToWake() && !this.dragon.method_6181() || this.dragon.isTimeToWake() && this.dragon.method_6181() || this.dragon.method_5968() != null || !this.dragon.method_5685().isEmpty())) {
            this.dragon.method_6179(false);
        }
        if (this.dragon.method_24345() && this.dragon.method_5642() != null) {
            this.dragon.method_24346(false);
        }
        if (this.dragon.blockBreakCounter <= 0) {
            this.dragon.blockBreakCounter = (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue();
        }
        this.dragon.updateBurnTarget();
        if (this.dragon.method_24345()) {
            if (this.dragon.getCommand() != 1 || this.dragon.method_5642() != null) {
                this.dragon.method_24346(false);
            }
        } else if (this.dragon.getCommand() == 1 && this.dragon.method_5642() == null) {
            this.dragon.method_24346(true);
        }
        if (this.dragon.method_24345()) {
            this.dragon.method_5942().method_6340();
        }
        if (this.dragon.method_6479()) {
            this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)18);
        }
        this.dragon.ticksStill = new class_2382((int)this.dragon.field_6014, (int)this.dragon.field_6036, (int)this.dragon.field_5969).method_10262((class_2382)this.dragon.method_24515()) <= 0.5 ? ++this.dragon.ticksStill : 0;
        if (this.dragon.method_5642() == null && this.dragon.isTackling() && !this.dragon.isFlying() && this.dragon.method_24828()) {
            ++this.dragon.tacklingTicks;
            if (this.dragon.tacklingTicks == 40) {
                this.dragon.tacklingTicks = 0;
                this.dragon.setTackling(false);
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.method_59922().method_43048(500) == 0 && !this.dragon.isModelDead() && !this.dragon.method_6113()) {
            this.dragon.roar();
        }
        if (this.dragon.isFlying() && this.dragon.method_5968() != null) {
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE) {
                this.dragon.setTackling(true);
            }
            if (this.dragon.isTackling() && this.dragon.method_5829().method_1012(2.0, 2.0, 2.0).method_994(this.dragon.method_5968().method_5829())) {
                this.dragon.usingGroundAttack = true;
                this.dragon.randomizeAttacks();
                this.attackTarget((class_1297)this.dragon.method_5968(), null, this.dragon.getDragonStage() * 3);
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
            }
        }
        if (this.dragon.method_5642() == null && this.dragon.isTackling() && (this.dragon.method_5968() == null || this.dragon.airAttack != IafDragonAttacks.Air.TACKLE)) {
            this.dragon.setTackling(false);
            this.dragon.randomizeAttacks();
        }
        if (this.dragon.method_5765()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.dragon.method_6179(false);
        }
        if (this.dragon.isFlying() && this.dragon.field_6012 % 40 == 0 || this.dragon.isFlying() && this.dragon.method_6113()) {
            this.dragon.method_6179(false);
        }
        if (!this.dragon.canMove()) {
            if (this.dragon.method_5968() != null) {
                this.dragon.method_5980(null);
                this.ticksAfterClearingTarget = this.dragon.method_37908().method_8510();
            }
            this.dragon.method_5942().method_6340();
        }
        if (!this.dragon.method_6181()) {
            this.dragon.updateCheckPlayer();
        }
        if (this.dragon.isModelDead() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.method_5642() == null) {
            if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 1) {
                this.dragon.switchNavigator(1);
            }
        } else if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 2) {
            this.dragon.switchNavigator(2);
        }
        if (this.dragon.method_5642() == null && !this.dragon.useFlyingPathFinder() && !this.dragon.isHovering() && this.dragon.navigatorType != 0) {
            this.dragon.switchNavigator(0);
        }
        if (this.dragon.method_5642() == null && !this.dragon.isOverAir() && this.dragon.doesWantToLand() && (this.dragon.isFlying() || this.dragon.isHovering()) && !this.dragon.method_5799()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isHovering()) {
            if (this.dragon.isFlying() && this.dragon.flyTicks > 40) {
                this.dragon.setHovering(false);
                this.dragon.setFlying(true);
            }
            ++this.dragon.hoverTicks;
        } else {
            this.dragon.hoverTicks = 0;
        }
        if (this.dragon.isHovering() && !this.dragon.isFlying()) {
            if (this.dragon.method_6113()) {
                this.dragon.setHovering(false);
            }
            if (this.dragon.method_5642() == null && this.dragon.doesWantToLand() && !this.dragon.method_24828() && !this.dragon.method_5799()) {
                this.dragon.method_18799(this.dragon.method_18798().method_1031(0.0, -0.25, 0.0));
            } else {
                if ((this.dragon.method_5642() == null || this.dragon.method_5642() instanceof DreadQueenEntity) && !this.dragon.isBeyondHeight()) {
                    double up = this.dragon.method_5799() ? 0.12 : 0.08;
                    this.dragon.method_18799(this.dragon.method_18798().method_1031(0.0, up, 0.0));
                }
                if (this.dragon.hoverTicks > 40) {
                    this.dragon.setHovering(false);
                    this.dragon.setFlying(true);
                    this.dragon.flyHovering = 0;
                    this.dragon.hoverTicks = 0;
                    this.dragon.flyTicks = 0;
                }
            }
        }
        if (this.dragon.method_6113()) {
            this.dragon.method_5942().method_6340();
        }
        if ((this.dragon.method_24828() || this.dragon.method_5799()) && this.dragon.flyTicks != 0) {
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.isAllowedToTriggerFlight() && this.dragon.isFlying() && this.dragon.doesWantToLand()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(this.dragon.isOverAir());
            if (!this.dragon.isOverAir()) {
                this.dragon.flyTicks = 0;
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.isFlying()) {
            ++this.dragon.flyTicks;
        }
        if ((this.dragon.isHovering() || this.dragon.isFlying()) && this.dragon.method_6113()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (!this.dragon.isFlying() && !this.dragon.isHovering() && (this.dragon.isAllowedToTriggerFlight() || this.dragon.method_23318() < (double)this.dragon.method_37908().method_31607()) && (this.dragon.method_59922().method_43048(this.dragon.getFlightChancePerTick()) == 0 || this.dragon.method_23318() < (double)this.dragon.method_37908().method_31607() || this.dragon.method_5968() != null && Math.abs(this.dragon.method_5968().method_23318() - this.dragon.method_23318()) > 5.0 || this.dragon.method_5799())) {
            this.dragon.setHovering(true);
            this.dragon.method_6179(false);
            this.dragon.method_24346(false);
            this.dragon.flyHovering = 0;
            this.dragon.hoverTicks = 0;
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.method_5968() != null && !DragonUtils.isAlive(this.dragon.method_5968())) {
            this.dragon.method_5980(null);
            this.ticksAfterClearingTarget = this.dragon.method_37908().method_8510();
        }
        if (!this.dragon.isAgingDisabled()) {
            this.dragon.setAgeInTicks(this.dragon.getAgeInTicks() + 1);
            if (this.dragon.getAgeInTicks() % 24000 == 0) {
                this.dragon.updateAttributes();
                this.dragon.growDragon(0);
            }
        }
        if ((Integer)IafCommonConfig.INSTANCE.dragon.hungerTickRate.getValue() > 0 && this.dragon.field_6012 % (Integer)IafCommonConfig.INSTANCE.dragon.hungerTickRate.getValue() == 0 && this.dragon.getHunger() > 0) {
            this.dragon.setHunger(this.dragon.getHunger() - 1);
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            this.dragon.usingGroundAttack = true;
            this.dragon.randomizeAttacks();
            this.dragon.method_5783(this.dragon.getBabyFireSound(), 1.0f, 1.0f);
        }
        if (this.dragon.isBreathingFire()) {
            if (this.dragon.method_6113() || this.dragon.isModelDead()) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireBreathTicks = 0;
            }
            if (this.dragon.burningTarget == null && (this.dragon.method_20802() > this.dragon.getDragonStage() * 25 || this.dragon.method_35057() != null && this.dragon.method_5685().contains(this.dragon.method_35057()) && this.dragon.fireStopTicks <= 0)) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireBreathTicks = 0;
            }
            if (this.dragon.fireStopTicks > 0 && this.dragon.method_35057() != null && this.dragon.method_5685().contains(this.dragon.method_35057())) {
                --this.dragon.fireStopTicks;
            }
        }
        if (this.dragon.isFlying()) {
            if (this.dragon.method_5968() != null && this.dragon.method_5829().method_1012(3.0, 3.0, 3.0).method_994(this.dragon.method_5968().method_5829())) {
                this.dragon.method_6121((class_1297)this.dragon.method_5968());
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && (this.dragon.field_5976 || this.dragon.method_24828())) {
                this.dragon.usingGroundAttack = true;
                if (this.dragon.method_5642() == null) {
                    this.dragon.setFlying(false);
                    this.dragon.setHovering(false);
                }
            }
            if (this.dragon.usingGroundAttack) {
                this.dragon.airAttack = IafDragonAttacks.Air.TACKLE;
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && this.dragon.method_5968() != null && this.dragon.isTargetBlocked(this.dragon.method_5968().method_19538())) {
                this.dragon.randomizeAttacks();
            }
        }
    }

    public boolean attackTarget(class_1297 target, class_1657 ridingPlayer, float damage) {
        if (ridingPlayer == null) {
            return target.method_5643(target.method_37908().method_48963().method_48812((class_1309)this.dragon), damage);
        }
        return target.method_5643(target.method_37908().method_48963().method_48815((class_1297)this.dragon, (class_1297)ridingPlayer), damage);
    }

    public void updateDragonClient() {
        if (!this.dragon.isModelDead()) {
            this.dragon.turn_buffer.calculateChainSwingBuffer(50.0f, 0, 4.0f, (class_1309)this.dragon);
            this.dragon.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (class_1309)this.dragon);
            if (!this.dragon.method_24828()) {
                this.dragon.roll_buffer.calculateChainFlapBuffer(55.0f, 1, 2.0f, 0.5f, (class_1309)this.dragon);
                this.dragon.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 1.0f, 0.5f, (class_1309)this.dragon);
                this.dragon.pitch_buffer_body.calculateChainWaveBuffer(80.0f, 10, 1.0f, 0.5f, (class_1309)this.dragon);
            }
        }
        this.dragon.walkCycle = this.dragon.walkCycle < 39 ? ++this.dragon.walkCycle : 0;
        if (this.dragon.getAnimation() == DragonBaseEntity.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 17 || this.dragon.getAnimationTick() == 22 || this.dragon.getAnimationTick() == 28)) {
            this.dragon.spawnGroundEffects();
        }
        this.dragon.legSolver.update(this.dragon, this.dragon.getRenderSize() / 3.0f);
        if (this.dragon.flightCycle == 11) {
            this.dragon.spawnGroundEffects();
        }
        if (this.dragon.isModelDead() && this.dragon.flightCycle != 0) {
            this.dragon.flightCycle = 0;
        }
    }

    public void updateDragonCommon() {
        boolean riding;
        boolean modelDead;
        boolean tackling;
        boolean diving;
        boolean hovering;
        boolean sitting;
        boolean sleeping;
        if ((double)this.dragon.fireBreathTicks > (double)this.dragon.getAgeInDays() * (Double)IafCommonConfig.INSTANCE.dragon.maxBreathTimeMul.getValue()) {
            this.dragon.fireBreathTicks = 0;
            this.dragon.setBreathingFire(false);
        }
        if (this.dragon.isBreathingFire()) {
            ++this.dragon.fireBreathTicks;
            if (this.dragon.burnProgress < 40) {
                ++this.dragon.burnProgress;
            }
        } else {
            this.dragon.burnProgress = 0;
        }
        if (this.dragon.flightCycle == 2 && !this.dragon.isDiving() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            float dragonSoundVolume = ((Integer)IafCommonConfig.INSTANCE.dragon.flapNoiseDistance.getValue()).intValue();
            float dragonSoundPitch = this.dragon.method_6017();
            this.dragon.method_5783((class_3414)IafSounds.DRAGON_FLIGHT.get(), dragonSoundVolume, dragonSoundPitch);
        }
        this.dragon.flightCycle = this.dragon.flightCycle < 58 ? (this.dragon.flightCycle += 2) : 0;
        boolean flying = this.dragon.isFlying();
        if (flying) {
            if (this.dragon.flyProgress < 20.0f) {
                this.dragon.flyProgress += 0.5f;
            }
        } else if (this.dragon.flyProgress > 0.0f) {
            this.dragon.flyProgress -= 2.0f;
        }
        boolean bl = sleeping = this.dragon.method_6113() && !this.dragon.isHovering() && !flying;
        if (sleeping) {
            if (this.dragon.sleepProgress < 20.0f) {
                this.dragon.sleepProgress += 0.5f;
            }
        } else if (this.dragon.sleepProgress > 0.0f) {
            this.dragon.sleepProgress -= 0.5f;
        }
        boolean bl2 = sitting = this.dragon.method_24345() && !this.dragon.isModelDead() && !sleeping;
        if (sitting) {
            if (this.dragon.sitProgress < 20.0f) {
                this.dragon.sitProgress += 0.5f;
            }
        } else if (this.dragon.sitProgress > 0.0f) {
            this.dragon.sitProgress -= 0.5f;
        }
        boolean fireBreathing = this.dragon.isBreathingFire();
        this.dragon.prevFireBreathProgress = this.dragon.fireBreathProgress;
        if (fireBreathing) {
            if (this.dragon.fireBreathProgress < 10.0f) {
                this.dragon.fireBreathProgress += 0.5f;
            }
        } else if (this.dragon.fireBreathProgress > 0.0f) {
            this.dragon.fireBreathProgress -= 0.5f;
        }
        boolean bl3 = hovering = this.dragon.isHovering() || this.dragon.isFlying() && this.dragon.airAttack == IafDragonAttacks.Air.HOVER_BLAST && this.dragon.method_5968() != null && this.dragon.method_5739((class_1297)this.dragon.method_5968()) < 17.0f;
        if (hovering) {
            if (this.dragon.hoverProgress < 20.0f) {
                this.dragon.hoverProgress += 0.5f;
            }
        } else if (this.dragon.hoverProgress > 0.0f) {
            this.dragon.hoverProgress -= 2.0f;
        }
        if (diving = this.dragon.isDiving()) {
            if (this.dragon.diveProgress < 10.0f) {
                this.dragon.diveProgress += 1.0f;
            }
        } else if (this.dragon.diveProgress > 0.0f) {
            this.dragon.diveProgress -= 2.0f;
        }
        boolean bl4 = tackling = this.dragon.isTackling() && this.dragon.isOverAir();
        if (tackling) {
            if (this.dragon.tackleProgress < 5.0f) {
                this.dragon.tackleProgress += 0.5f;
            }
        } else if (this.dragon.tackleProgress > 0.0f) {
            this.dragon.tackleProgress -= 1.5f;
        }
        if (modelDead = this.dragon.isModelDead()) {
            if (this.dragon.modelDeadProgress < 20.0f) {
                this.dragon.modelDeadProgress += 0.5f;
            }
        } else if (this.dragon.modelDeadProgress > 0.0f) {
            this.dragon.modelDeadProgress -= 0.5f;
        }
        boolean bl5 = riding = this.dragon.method_5765() && this.dragon.method_5854() != null && this.dragon.method_5854() instanceof class_1657;
        if (riding) {
            if (this.dragon.ridingProgress < 20.0f) {
                this.dragon.ridingProgress += 0.5f;
            }
        } else if (this.dragon.ridingProgress > 0.0f) {
            this.dragon.ridingProgress -= 0.5f;
        }
        if (this.dragon.hasHadHornUse) {
            this.dragon.hasHadHornUse = false;
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            if (this.dragon.method_37908().field_9236) {
                this.dragon.spawnBabyParticles();
            }
            this.dragon.randomizeAttacks();
        }
    }

    public void updateDragonAttack() {
        class_1309 target;
        double dist;
        class_1657 ridingPlayer = this.dragon.getRidingPlayer();
        if (this.dragon.isPlayingAttackAnimation() && this.dragon.method_5968() != null && this.dragon.method_6057((class_1297)this.dragon.method_5968()) && (dist = (double)this.dragon.method_5739((class_1297)(target = this.dragon.method_5968()))) < (double)this.dragon.getRenderSize() * 0.2574 * 2.0 + 2.0) {
            if (this.dragon.getAnimation() == DragonBaseEntity.ANIMATION_BITE) {
                if (this.dragon.getAnimationTick() > 15 && this.dragon.getAnimationTick() < 25) {
                    this.attackTarget((class_1297)target, ridingPlayer, (int)this.dragon.method_5996(class_5134.field_23721).method_6194());
                    this.dragon.usingGroundAttack = this.dragon.method_59922().method_43056();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == DragonBaseEntity.ANIMATION_TAILWHACK) {
                if (this.dragon.getAnimationTick() > 20 && this.dragon.getAnimationTick() < 30) {
                    this.attackTarget((class_1297)target, ridingPlayer, (int)this.dragon.method_5996(class_5134.field_23721).method_6194());
                    target.method_6005((double)((float)this.dragon.getDragonStage() * 0.6f), (double)class_3532.method_15374((float)(this.dragon.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.dragon.method_36454() * ((float)Math.PI / 180)))));
                    this.dragon.usingGroundAttack = this.dragon.method_59922().method_43056();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == DragonBaseEntity.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 15 || this.dragon.getAnimationTick() == 25 || this.dragon.getAnimationTick() == 35)) {
                this.attackTarget((class_1297)target, ridingPlayer, (int)this.dragon.method_5996(class_5134.field_23721).method_6194());
                target.method_6005((double)((float)this.dragon.getDragonStage() * 0.6f), (double)class_3532.method_15374((float)(this.dragon.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.dragon.method_36454() * ((float)Math.PI / 180)))));
                this.dragon.usingGroundAttack = this.dragon.method_59922().method_43056();
                this.dragon.randomizeAttacks();
            }
        }
    }

    public void debug() {
        String side = this.dragon.method_37908().field_9236 ? "CLIENT" : "SERVER";
        String owner = this.dragon.method_35057() == null ? "null" : this.dragon.method_35057().method_5477().getString();
        String attackTarget = this.dragon.method_5968() == null ? "null" : this.dragon.method_5968().method_5477().getString();
        IceAndFire.LOGGER.warn("DRAGON DEBUG[{}]:\nStage: {}\nAge: {}\nVariant: {}\nOwner: {}\nAttack Target: {}\nFlying: {}\nHovering: {}\nHovering Time: {}\nWidth: {}\nMoveHelper: {}\nGround Attack: {}\nAir Attack: {}\nTackling: {}", new Object[]{side, this.dragon.getDragonStage(), this.dragon.getAgeInDays(), this.dragon.getVariant(), owner, attackTarget, this.dragon.isFlying(), this.dragon.isHovering(), this.dragon.hoverTicks, Float.valueOf(this.dragon.method_17681()), this.dragon.method_5962(), this.dragon.groundAttack, this.dragon.airAttack, this.dragon.isTackling()});
    }
}

