/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.entity.AmphithereEntity;
import com.iafenvoy.iceandfire.entity.CockatriceEntity;
import com.iafenvoy.iceandfire.entity.CyclopsEntity;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.GhostEntity;
import com.iafenvoy.iceandfire.entity.HydraEntity;
import com.iafenvoy.iceandfire.entity.HydraHeadEntity;
import com.iafenvoy.iceandfire.entity.MultipartPartEntity;
import com.iafenvoy.iceandfire.entity.StoneStatueEntity;
import com.iafenvoy.iceandfire.entity.ai.EntitySheepAIFollowCyclopsGoal;
import com.iafenvoy.iceandfire.entity.ai.VillagerAIFearUntamedGoal;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.ChainItem;
import com.iafenvoy.iceandfire.item.DragonHornItem;
import com.iafenvoy.iceandfire.item.armor.DragonScaleArmorItem;
import com.iafenvoy.iceandfire.item.armor.DragonSteelArmorItem;
import com.iafenvoy.iceandfire.item.armor.TrollArmorItem;
import com.iafenvoy.iceandfire.item.component.StoneStatusComponent;
import com.iafenvoy.iceandfire.network.payload.PlayerHitMultipartC2SPayload;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.object.RegistryHelper;
import com.iafenvoy.uranus.util.RandomHelper;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3966;
import net.minecraft.class_4739;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public final class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    public static final String BOLT_DONT_DESTROY_LOOT = "iceandfire.bolt_skip_loot";
    private static final Predicate<class_1309> VILLAGER_FEAR = entity -> {
        IVillagerFear fear;
        return entity instanceof IVillagerFear && (fear = (IVillagerFear)entity).shouldFear();
    };

    private static void signalChickenAlarm(class_1309 chicken, class_1309 attacker) {
        float d0 = ((Integer)IafCommonConfig.INSTANCE.cockatrice.chickenSearchLength.getValue()).intValue();
        List list = chicken.method_37908().method_18467(CockatriceEntity.class, new class_238(chicken.method_23317(), chicken.method_23318(), chicken.method_23321(), chicken.method_23317() + 1.0, chicken.method_23318() + 1.0, chicken.method_23321() + 1.0).method_1009((double)d0, 10.0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (CockatriceEntity cockatrice : list) {
            if (attacker instanceof CockatriceEntity || DragonUtils.hasSameOwner(cockatrice, (class_1297)attacker)) continue;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                if (player.method_7337() || cockatrice.method_6171((class_1309)player)) continue;
                cockatrice.method_5980((class_1309)player);
                continue;
            }
            cockatrice.method_5980(attacker);
        }
    }

    private static void signalAmphithereAlarm(class_1309 villager, class_1309 attacker) {
        float d0 = ((Double)IafCommonConfig.INSTANCE.amphithere.villagerSearchLength.getValue()).floatValue();
        List list = villager.method_37908().method_18467(AmphithereEntity.class, new class_238(villager.method_23317() - 1.0, villager.method_23318() - 1.0, villager.method_23321() - 1.0, villager.method_23317() + 1.0, villager.method_23318() + 1.0, villager.method_23321() + 1.0).method_1009((double)d0, (double)d0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (class_1297 entity : list) {
            if (!(entity instanceof AmphithereEntity)) continue;
            AmphithereEntity amphithere = (AmphithereEntity)entity;
            if (attacker instanceof AmphithereEntity || DragonUtils.hasSameOwner(amphithere, (class_1297)attacker)) continue;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                if (player.method_7337() || amphithere.method_6171((class_1309)player)) continue;
                amphithere.method_5980((class_1309)player);
                continue;
            }
            amphithere.method_5980(attacker);
        }
    }

    public static boolean isRidingOrBeingRiddenBy(class_1297 first, class_1297 entityIn) {
        if (first == null || entityIn == null) {
            return false;
        }
        for (class_1297 entity : first.method_5685()) {
            if (!entity.equals((Object)entityIn) && !ServerEvents.isRidingOrBeingRiddenBy(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    public static float onEntityDamage(class_1309 entity, class_1282 source, float amount) {
        float multi;
        if (source.method_48789(class_8103.field_42247)) {
            multi = 1.0f;
            if (entity.method_6118(class_1304.field_6169).method_7909() instanceof TrollArmorItem) {
                multi -= 0.1f;
            }
            if (entity.method_6118(class_1304.field_6174).method_7909() instanceof TrollArmorItem) {
                multi -= 0.3f;
            }
            if (entity.method_6118(class_1304.field_6172).method_7909() instanceof TrollArmorItem) {
                multi -= 0.2f;
            }
            if (entity.method_6118(class_1304.field_6166).method_7909() instanceof TrollArmorItem) {
                multi -= 0.1f;
            }
            amount *= multi;
        }
        if (source.method_49708(IafDamageTypes.DRAGON_FIRE_TYPE) || source.method_49708(IafDamageTypes.DRAGON_ICE_TYPE) || source.method_49708(IafDamageTypes.DRAGON_LIGHTNING_TYPE)) {
            multi = 1.0f;
            if (entity.method_6118(class_1304.field_6169).method_7909() instanceof DragonScaleArmorItem || entity.method_6118(class_1304.field_6169).method_7909() instanceof DragonSteelArmorItem) {
                multi -= 0.1f;
            }
            if (entity.method_6118(class_1304.field_6174).method_7909() instanceof DragonScaleArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof DragonSteelArmorItem) {
                multi -= 0.3f;
            }
            if (entity.method_6118(class_1304.field_6172).method_7909() instanceof DragonScaleArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof DragonSteelArmorItem) {
                multi -= 0.2f;
            }
            if (entity.method_6118(class_1304.field_6166).method_7909() instanceof DragonScaleArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof DragonSteelArmorItem) {
                multi -= 0.1f;
            }
            amount *= multi;
        }
        return amount;
    }

    public static void onLivingSetTarget(class_1297 tracking, class_3222 player) {
        if (tracking instanceof class_1309) {
            class_1309 target = (class_1309)tracking;
            if (target.method_5864().method_20210(IafEntityTags.CHICKENS)) {
                ServerEvents.signalChickenAlarm(target, (class_1309)player);
            } else if (DragonUtils.isVillager((class_1297)target)) {
                ServerEvents.signalAmphithereAlarm(target, (class_1309)player);
            }
        }
    }

    public static EventResult onPlayerAttack(class_1657 player, class_1937 world, class_1297 entity, class_1268 hand, @Nullable class_3966 hitResult) {
        if (entity != null && entity.method_5864().method_20210(IafEntityTags.SHEEP)) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.cyclops.sheepSearchLength.getValue()).intValue();
            List list = entity.method_37908().method_8335(entity, entity.method_5829().method_1009((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (class_1297 e : list) {
                    CyclopsEntity cyclops;
                    if (!(e instanceof CyclopsEntity) || (cyclops = (CyclopsEntity)e).isBlinded() || player.method_7337()) continue;
                    cyclops.method_5980((class_1309)player);
                }
            }
        }
        if (entity instanceof StoneStatueEntity) {
            StoneStatueEntity statue = (StoneStatueEntity)entity;
            statue.method_6033(statue.method_6063());
            if (player != null) {
                class_1799 stack = player.method_6047();
                entity.method_5783(class_3417.field_15026, 2.0f, 0.5f + (float)(RandomHelper.nextDouble((double)-1.0, (double)1.0) * 0.2 + 0.5));
                if (stack.method_31573(class_3489.field_42614)) {
                    statue.setCrackAmount(statue.getCrackAmount() + 1);
                    if (statue.getCrackAmount() > 9) {
                        class_2487 writtenTag = new class_2487();
                        entity.method_5647(writtenTag);
                        entity.method_5783(class_3417.field_15026, 2.0f, (float)(RandomHelper.nextDouble((double)-1.0, (double)1.0) * 0.2 + 0.5));
                        entity.method_5650(class_1297.class_5529.field_26998);
                        if (class_1890.method_8225((class_6880)RegistryHelper.getEnchantment((class_5455)world.method_30349(), (class_5321)class_1893.field_9099), (class_1799)stack) > 0) {
                            class_1799 statuette = new class_1799((class_1935)IafItems.STONE_STATUE.get());
                            statuette.method_57379((class_9331)IafDataComponents.STONE_STATUS.get(), (Object)new StoneStatusComponent(statue.getTrappedEntityTypeString().equalsIgnoreCase("minecraft:player"), statue.getTrappedEntityTypeString(), writtenTag));
                            if (!statue.method_37908().field_9236) {
                                statue.method_5699(statuette, 1.0f);
                            }
                        } else if (!statue.method_37908().field_9236) {
                            statue.method_5870((class_1935)class_2246.field_10445, 2 + player.method_59922().method_43048(4));
                        }
                        statue.method_5650(class_1297.class_5529.field_26998);
                    }
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.interruptDefault();
        }
        if (entity instanceof MultipartPartEntity) {
            MultipartPartEntity mutlipartPart = (MultipartPartEntity)entity;
            class_1297 parent = mutlipartPart.getParent();
            try {
                if (parent != null) {
                    player.method_7324(parent);
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Exception thrown while interacting with entity.", (Throwable)e);
            }
            int extraData = 0;
            if (mutlipartPart instanceof HydraHeadEntity) {
                HydraHeadEntity hydraHead = (HydraHeadEntity)mutlipartPart;
                if (parent instanceof HydraEntity) {
                    HydraEntity hydra = (HydraEntity)parent;
                    extraData = hydraHead.headIndex;
                    hydra.triggerHeadFlags(extraData);
                }
            }
            if (mutlipartPart.method_37908().field_9236 && parent != null) {
                NetworkManager.sendToServer((class_8710)new PlayerHitMultipartC2SPayload(parent.method_5628(), extraData));
            }
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (entity.method_5864().method_20210(IafEntityTags.CHICKENS)) {
                ServerEvents.signalChickenAlarm(livingEntity, (class_1309)player);
            } else if (DragonUtils.isVillager(entity)) {
                ServerEvents.signalAmphithereAlarm(livingEntity, (class_1309)player);
            }
        }
        return EventResult.pass();
    }

    public static EventResult onEntityDie(class_1309 entity, class_1282 damageSource) {
        class_1309 attacker;
        if (entity.method_37908().field_9236) {
            return EventResult.pass();
        }
        ChainData chainData = ChainData.get(entity);
        if (!chainData.getChainedTo().isEmpty()) {
            class_1542 entityitem = new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), new class_1799((class_1935)IafItems.CHAIN.get(), chainData.getChainedTo().size()));
            entityitem.method_6988();
            entity.method_37908().method_8649((class_1297)entityitem);
            chainData.clearChains();
        }
        if (entity.method_5667().equals(ALEX_UUID)) {
            entity.method_5699(new class_1799((class_1935)IafItems.WEEZER_BLUE_ALBUM.get()), 1.0f);
        }
        if (entity instanceof class_1657 && ((Boolean)IafCommonConfig.INSTANCE.ghost.fromPlayerDeaths.getValue()).booleanValue() && (attacker = entity.method_6065()) instanceof class_1657 && entity.method_59922().method_43048(3) == 0) {
            boolean flag;
            class_1283 combat = entity.method_6066();
            class_1281 entry = combat.method_5544();
            boolean bl = flag = entry != null && (entry.comp_1535().method_49708(class_8111.field_42345) || entry.comp_1535().method_49708(class_8111.field_42342) || entry.comp_1535().method_49708(class_8111.field_42338));
            if (entity.method_6059(class_1294.field_5899)) {
                flag = true;
            }
            if (flag) {
                class_1937 world = entity.method_37908();
                GhostEntity ghost = (GhostEntity)((class_1299)IafEntities.GHOST.get()).method_5883(world);
                assert (ghost != null);
                ghost.method_5719((class_1297)entity);
                if (world instanceof class_5425) {
                    class_5425 serverWorldAccess = (class_5425)world;
                    ghost.method_5943(serverWorldAccess, world.method_8404(entity.method_24515()), class_3730.field_16469, null);
                    world.method_8649((class_1297)ghost);
                }
                ghost.setDaytimeMode(true);
            }
        }
        return EventResult.pass();
    }

    public static EventResult onEntityInteract(class_1657 player, class_1297 entity, class_1268 hand) {
        if (entity instanceof class_1309) {
            ChainData chainData;
            class_1309 target = (class_1309)entity;
            if (!player.method_7325() && (chainData = ChainData.get(target)).isChainedTo(entity.method_5667())) {
                chainData.removeChain(entity.method_5667());
                if (!player.method_37908().field_9236) {
                    entity.method_5870((class_1935)IafItems.CHAIN.get(), 1);
                }
                return EventResult.interruptTrue();
            }
        }
        if (entity instanceof MultipartPartEntity) {
            MultipartPartEntity multipart = (MultipartPartEntity)entity;
            class_1792 class_17922 = player.method_5998(hand).method_7909();
            if (class_17922 instanceof DragonHornItem) {
                DragonHornItem horn = (DragonHornItem)class_17922;
                class_17922 = multipart.getParent();
                if (class_17922 instanceof class_1309) {
                    class_1309 living = (class_1309)class_17922;
                    horn.method_7847(player.method_5998(hand), player, living, hand);
                }
            }
        }
        return EventResult.pass();
    }

    public static EventResult onPlayerRightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        class_1937 world = player.method_37908();
        if (world.method_8320(pos).method_26204() instanceof class_4739 && !player.method_7337()) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.dragon.goldSearchLength.getValue()).intValue();
            List list = world.method_8335((class_1297)player, player.method_5829().method_1009((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (class_1297 entity : list) {
                    DragonBaseEntity dragon;
                    if (!(entity instanceof DragonBaseEntity) || (dragon = (DragonBaseEntity)entity).method_6181() || dragon.isModelDead() || dragon.method_6171((class_1309)player)) continue;
                    dragon.method_6179(false);
                    dragon.method_24346(false);
                    dragon.method_5980((class_1309)player);
                }
            }
        }
        if (world.method_8320(pos).method_26204() instanceof class_2544) {
            ChainItem.attachToFence(player, world, pos);
        }
        return EventResult.pass();
    }

    public static EventResult onBreakBlock(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, @Nullable IntValue xp) {
        if (player != null && (state.method_26204() instanceof class_4739 || state.method_27852((class_2248)IafBlocks.GOLD_PILE.get()) || state.method_27852((class_2248)IafBlocks.SILVER_PILE.get()) || state.method_27852((class_2248)IafBlocks.COPPER_PILE.get()))) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.dragon.goldSearchLength.getValue()).intValue();
            List list = world.method_8335((class_1297)player, player.method_5829().method_1009((double)dist, (double)dist, (double)dist));
            if (list.isEmpty()) {
                return EventResult.pass();
            }
            for (class_1297 entity : list) {
                DragonBaseEntity dragon;
                if (!(entity instanceof DragonBaseEntity) || (dragon = (DragonBaseEntity)entity).method_6181() || dragon.isModelDead() || dragon.method_6171((class_1309)player) || player.method_7337()) continue;
                dragon.method_6179(false);
                dragon.method_24346(false);
                dragon.method_5980((class_1309)player);
            }
        }
        return EventResult.pass();
    }

    public static void onPlayerLeaveEvent(class_1657 player) {
        if (player != null && !player.method_5685().isEmpty()) {
            for (class_1297 entity : player.method_5685()) {
                entity.method_5848();
            }
        }
    }

    public static boolean onEntityJoinWorld(class_1297 entity, class_1937 world) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            try {
                if (mob.method_5864().method_20210(IafEntityTags.SHEEP) && mob instanceof class_1429) {
                    class_1429 animal = (class_1429)mob;
                    animal.field_6201.method_6277(8, (class_1352)new EntitySheepAIFollowCyclopsGoal(animal, 1.2));
                }
                if (mob.method_5864().method_20210(IafEntityTags.VILLAGERS) && ((Boolean)IafCommonConfig.INSTANCE.dragon.villagersFear.getValue()).booleanValue()) {
                    mob.field_6201.method_6277(1, (class_1352)new VillagerAIFearUntamedGoal((class_1314)mob, class_1309.class, 8.0f, 0.8, 0.8, VILLAGER_FEAR));
                }
                if (mob.method_5864().method_20210(IafEntityTags.FEAR_DRAGONS) && ((Boolean)IafCommonConfig.INSTANCE.dragon.animalsFear.getValue()).booleanValue()) {
                    mob.field_6201.method_6277(1, (class_1352)new VillagerAIFearUntamedGoal((class_1314)mob, class_1309.class, 30.0f, 1.0, 0.5, e -> {
                        IAnimalFear fear;
                        return e instanceof IAnimalFear && (fear = (IAnimalFear)e).shouldAnimalsFear((class_1297)mob);
                    }));
                }
            }
            catch (Exception e2) {
                IceAndFire.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
            }
        }
        return true;
    }

    public static EventResult onLivingHurt(class_1309 entity, class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42336) && entity.method_6118(class_1304.field_6169).method_31574((class_1792)IafItems.DRAGONSTEEL_LIGHTNING_HELMET.get()) && entity.method_6118(class_1304.field_6174).method_31574((class_1792)IafItems.DRAGONSTEEL_LIGHTNING_CHESTPLATE.get()) && entity.method_6118(class_1304.field_6172).method_31574((class_1792)IafItems.DRAGONSTEEL_LIGHTNING_LEGGINGS.get()) && entity.method_6118(class_1304.field_6166).method_31574((class_1792)IafItems.DRAGONSTEEL_LIGHTNING_BOOTS.get())) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

