/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.entity.PixieEntity;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHouseS2CPayload;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.uranus.ServerHelper;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

public class PixieHouseBlockEntity
extends class_2586 {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    private final Random rand;
    public int houseType;
    public boolean hasPixie;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public class_2371<class_1799> pixieItems = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public PixieHouseBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)IafBlockEntities.PIXIE_HOUSE.get(), pos, state);
        this.rand = new Random();
    }

    public static int getHouseTypeFromBlock(class_2248 block) {
        if (block == IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()) {
            return 1;
        }
        if (block == IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()) {
            return 0;
        }
        if (block == IafBlocks.PIXIE_HOUSE_OAK.get()) {
            return 3;
        }
        if (block == IafBlocks.PIXIE_HOUSE_BIRCH.get()) {
            return 2;
        }
        if (block == IafBlocks.PIXIE_HOUSE_SPRUCE.get()) {
            return 5;
        }
        if (block == IafBlocks.PIXIE_HOUSE_DARK_OAK.get()) {
            return 4;
        }
        return 0;
    }

    public static void tickClient(class_1937 level, class_2338 pos, class_2680 state, PixieHouseBlockEntity entityPixieHouse) {
        if (entityPixieHouse.hasPixie) {
            level.method_8406((class_2394)IafParticles.PIXIE_DUST.get(), (double)((float)pos.method_10263() + 0.5f) + (double)(entityPixieHouse.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)pos.method_10264() + (double)(entityPixieHouse.rand.nextFloat() * 0.6f), (double)((float)pos.method_10260() + 0.5f) + (double)(entityPixieHouse.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)PixieEntity.PARTICLE_RGB[entityPixieHouse.pixieType][0], (double)PixieEntity.PARTICLE_RGB[entityPixieHouse.pixieType][1], (double)PixieEntity.PARTICLE_RGB[entityPixieHouse.pixieType][2]);
        }
    }

    public static void tickServer(class_1937 level, class_2338 pos, class_2680 state, PixieHouseBlockEntity entityPixieHouse) {
        if (entityPixieHouse.hasPixie && ThreadLocalRandom.current().nextInt(100) == 0) {
            entityPixieHouse.releasePixie();
        }
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("HouseType", this.houseType);
        nbt.method_10556("HasPixie", this.hasPixie);
        nbt.method_10569("PixieType", this.pixieType);
        nbt.method_10556("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            nbt.method_25927("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        class_1262.method_5426((class_2487)nbt, this.pixieItems, (class_7225.class_7874)registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38242(registryLookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.houseType = nbt.method_10550("HouseType");
        this.hasPixie = nbt.method_10577("HasPixie");
        this.pixieType = nbt.method_10550("PixieType");
        this.tamedPixie = nbt.method_10577("TamedPixie");
        if (nbt.method_25928("PixieOwnerUUID")) {
            this.pixieOwnerUUID = nbt.method_25926("PixieOwnerUUID");
        }
        this.pixieItems = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.pixieItems, (class_7225.class_7874)registryLookup);
    }

    public void releasePixie() {
        PixieEntity pixie = new PixieEntity((class_1299<? extends PixieEntity>)((class_1299)IafEntities.PIXIE.get()), this.field_11863);
        pixie.method_5641((float)this.field_11867.method_10263() + 0.5f, (float)this.field_11867.method_10264() + 1.0f, (float)this.field_11867.method_10260() + 0.5f, ThreadLocalRandom.current().nextInt(360), 0.0f);
        pixie.method_6122(class_1268.field_5808, (class_1799)this.pixieItems.getFirst());
        pixie.setColor(this.pixieType);
        pixie.ticksUntilHouseAI = 500;
        pixie.method_6173(this.tamedPixie, true);
        pixie.method_6174(this.pixieOwnerUUID);
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8649((class_1297)pixie);
        }
        this.hasPixie = false;
        this.pixieType = 0;
        if (!this.field_11863.field_9236) {
            ServerHelper.sendToAll((class_8710)new UpdatePixieHouseS2CPayload(this.field_11867, false, 0));
        }
    }
}

