/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.SeaSerpentType;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.entity.LightningDragonEntity;
import com.iafenvoy.iceandfire.impl.ParticleProviderHolder;
import com.iafenvoy.iceandfire.item.DragonHornItem;
import com.iafenvoy.iceandfire.item.SummoningCrystalItem;
import com.iafenvoy.iceandfire.particle.BloodParticle;
import com.iafenvoy.iceandfire.particle.DragonFlameParticle;
import com.iafenvoy.iceandfire.particle.DragonFrostParticle;
import com.iafenvoy.iceandfire.particle.DreadPortalParticle;
import com.iafenvoy.iceandfire.particle.DreadTorchParticle;
import com.iafenvoy.iceandfire.particle.GhostAppearanceParticle;
import com.iafenvoy.iceandfire.particle.HydraBreathParticle;
import com.iafenvoy.iceandfire.particle.PixieDustParticle;
import com.iafenvoy.iceandfire.particle.SerpentBubbleParticle;
import com.iafenvoy.iceandfire.particle.SirenMusicParticle;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.render.block.DreadPortalBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.DreadSpawnerBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.EggInIceBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.JarBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.LecternBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.PixieHouseBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.block.PodiumBlockEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.AmphithereArrowEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.AmphithereEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.ChainTieEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.CockatriceEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.CyclopsEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DeathWormEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DragonArrowEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DragonBaseEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DragonChargeEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DragonEggEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DragonSkullEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadBeastEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadGhoulEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadHorseEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadKnightEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadLichEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadLichSkullEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadScuttlerEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.DreadThrallEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.GhostEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.GhostSwordEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.GorgonEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.HippocampusEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.HippogryphEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.HydraArrowEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.HydraEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.LightningDragonChargeEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.LightningDragonEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.MobSkullEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.NothingEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.PixieEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.SeaSerpentArrowEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.SeaSerpentEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.SirenEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.StoneStatueEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.StymphalianArrowEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.StymphalianBirdEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.StymphalianFeatherEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.TideTridentEntityRenderer;
import com.iafenvoy.iceandfire.render.entity.TrollEntityRenderer;
import com.iafenvoy.iceandfire.render.item.DeathwormGauntletRenderer;
import com.iafenvoy.iceandfire.render.item.GorgonHeadRenderer;
import com.iafenvoy.iceandfire.render.item.MiscItemRenderer;
import com.iafenvoy.iceandfire.render.item.TideTridentItemRenderer;
import com.iafenvoy.iceandfire.render.item.TrollWeaponRenderer;
import com.iafenvoy.iceandfire.render.item.armor.BasicArmorRenderer;
import com.iafenvoy.iceandfire.render.item.armor.ScaleArmorRenderer;
import com.iafenvoy.iceandfire.render.model.animator.FireDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.LightningTabulaDragonAnimator;
import com.iafenvoy.iceandfire.render.model.armor.CopperArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.DeathWormArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.DragonSteelFireArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.DragonSteelIceArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.DragonSteelLightningArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.SeaSerpentArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.SilverArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.TrollArmorModel;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.iafenvoy.uranus.client.render.DynamicItemRenderer;
import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import net.minecraft.class_826;
import net.minecraft.class_953;

@Environment(value=EnvType.CLIENT)
public final class IafRenderers {
    public static final class_2960 FIRE_DRAGON = class_2960.method_60655((String)"iceandfire", (String)"firedragon/firedragon_ground");
    public static final class_2960 ICE_DRAGON = class_2960.method_60655((String)"iceandfire", (String)"icedragon/icedragon_ground");
    public static final class_2960 LIGHTNING_DRAGON = class_2960.method_60655((String)"iceandfire", (String)"lightningdragon/lightningdragon_ground");
    public static final class_2960 SEA_SERPENT = class_2960.method_60655((String)"iceandfire", (String)"seaserpent/seaserpent_base");

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(IafEntities.FIRE_DRAGON, x -> new DragonBaseEntityRenderer(x, TabulaModelHandlerHelper.getModel((class_2960)FIRE_DRAGON, (MemorizeSupplier)new MemorizeSupplier(FireDragonTabulaModelAnimator::new))));
        EntityRendererRegistry.register(IafEntities.ICE_DRAGON, manager -> new DragonBaseEntityRenderer(manager, TabulaModelHandlerHelper.getModel((class_2960)ICE_DRAGON, (MemorizeSupplier)new MemorizeSupplier(IceDragonTabulaModelAnimator::new))));
        EntityRendererRegistry.register(IafEntities.LIGHTNING_DRAGON, manager -> new LightningDragonEntityRenderer(manager, (TabulaModel<LightningDragonEntity>)TabulaModelHandlerHelper.getModel((class_2960)LIGHTNING_DRAGON, (MemorizeSupplier)new MemorizeSupplier(LightningTabulaDragonAnimator::new))));
        EntityRendererRegistry.register(IafEntities.DRAGON_EGG, DragonEggEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_ARROW, DragonArrowEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_SKULL, DragonSkullEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.FIRE_DRAGON_CHARGE, manager -> new DragonChargeEntityRenderer(manager, true));
        EntityRendererRegistry.register(IafEntities.ICE_DRAGON_CHARGE, manager -> new DragonChargeEntityRenderer(manager, false));
        EntityRendererRegistry.register(IafEntities.LIGHTNING_DRAGON_CHARGE, LightningDragonChargeEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HIPPOGRYPH_EGG, class_953::new);
        EntityRendererRegistry.register(IafEntities.HIPPOGRYPH, HippogryphEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.STONE_STATUE, StoneStatueEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.GORGON, GorgonEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.PIXIE, PixieEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.CYCLOPS, CyclopsEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.SIREN, SirenEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HIPPOCAMPUS, HippocampusEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DEATH_WORM, DeathWormEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DEATH_WORM_EGG, class_953::new);
        EntityRendererRegistry.register(IafEntities.COCKATRICE, CockatriceEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.COCKATRICE_EGG, class_953::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_BIRD, StymphalianBirdEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_FEATHER, StymphalianFeatherEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_ARROW, StymphalianArrowEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.TROLL, TrollEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.AMPHITHERE, AmphithereEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.AMPHITHERE_ARROW, AmphithereArrowEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT, SeaSerpentEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT_BUBBLES, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT_ARROW, SeaSerpentArrowEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.CHAIN_TIE, ChainTieEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.PIXIE_CHARGE, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.TIDE_TRIDENT, TideTridentEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.MOB_SKULL, MobSkullEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_SCUTTLER, DreadScuttlerEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_GHOUL, DreadGhoulEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_BEAST, DreadBeastEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_SCUTTLER, DreadScuttlerEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_THRALL, DreadThrallEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_LICH, DreadLichEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_LICH_SKULL, DreadLichSkullEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_KNIGHT, DreadKnightEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DREAD_HORSE, DreadHorseEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HYDRA, HydraEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_BREATH, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_ARROW, HydraArrowEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.SLOW_MULTIPART, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_MULTIPART, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.CYCLOPS_MULTIPART, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_MULTIPART, NothingEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.GHOST, GhostEntityRenderer::new);
        EntityRendererRegistry.register(IafEntities.GHOST_SWORD, GhostSwordEntityRenderer::new);
    }

    public static void registerParticleRenderers(Consumer<ParticleProviderHolder<?>> consumer) {
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.BLOOD.get(), BloodParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.DRAGON_FLAME.get(), DragonFlameParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.DRAGON_FROST.get(), DragonFrostParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.DREAD_PORTAL.get(), DreadPortalParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.DREAD_TORCH.get(), DreadTorchParticle::factory));
        consumer.accept(new ParticleProviderHolder<class_2400>((class_2396)IafParticles.GHOST_APPEARANCE.get(), GhostAppearanceParticle.factory()));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.HYDRA_BREATH.get(), HydraBreathParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.PIXIE_DUST.get(), PixieDustParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.SERPENT_BUBBLE.get(), SerpentBubbleParticle::factory));
        consumer.accept(new ParticleProviderHolder((class_2396)IafParticles.SIREN_MUSIC.get(), SirenMusicParticle::factory));
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.PODIUM.get()), PodiumBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.IAF_LECTERN.get()), LecternBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.EGG_IN_ICE.get()), EggInIceBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.PIXIE_HOUSE.get()), PixieHouseBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.PIXIE_JAR.get()), JarBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.DREAD_PORTAL.get()), DreadPortalBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.DREAD_SPAWNER.get()), DreadSpawnerBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)IafBlockEntities.GHOST_CHEST.get()), class_826::new);
    }

    public static void registerArmorRenderers() {
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)CopperArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.COPPER_HELMET.get(), (class_1935)IafItems.COPPER_CHESTPLATE.get(), (class_1935)IafItems.COPPER_LEGGINGS.get(), (class_1935)IafItems.COPPER_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DeathWormArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DEATHWORM_WHITE_HELMET.get(), (class_1935)IafItems.DEATHWORM_WHITE_CHESTPLATE.get(), (class_1935)IafItems.DEATHWORM_WHITE_LEGGINGS.get(), (class_1935)IafItems.DEATHWORM_WHITE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DeathWormArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DEATHWORM_YELLOW_HELMET.get(), (class_1935)IafItems.DEATHWORM_YELLOW_CHESTPLATE.get(), (class_1935)IafItems.DEATHWORM_YELLOW_LEGGINGS.get(), (class_1935)IafItems.DEATHWORM_YELLOW_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DeathWormArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DEATHWORM_RED_HELMET.get(), (class_1935)IafItems.DEATHWORM_RED_CHESTPLATE.get(), (class_1935)IafItems.DEATHWORM_RED_LEGGINGS.get(), (class_1935)IafItems.DEATHWORM_RED_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DragonSteelFireArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DRAGONSTEEL_FIRE_HELMET.get(), (class_1935)IafItems.DRAGONSTEEL_FIRE_CHESTPLATE.get(), (class_1935)IafItems.DRAGONSTEEL_FIRE_LEGGINGS.get(), (class_1935)IafItems.DRAGONSTEEL_FIRE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DragonSteelIceArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DRAGONSTEEL_ICE_HELMET.get(), (class_1935)IafItems.DRAGONSTEEL_ICE_CHESTPLATE.get(), (class_1935)IafItems.DRAGONSTEEL_ICE_LEGGINGS.get(), (class_1935)IafItems.DRAGONSTEEL_ICE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)DragonSteelLightningArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.DRAGONSTEEL_LIGHTNING_HELMET.get(), (class_1935)IafItems.DRAGONSTEEL_LIGHTNING_CHESTPLATE.get(), (class_1935)IafItems.DRAGONSTEEL_LIGHTNING_LEGGINGS.get(), (class_1935)IafItems.DRAGONSTEEL_LIGHTNING_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)SilverArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)IafItems.SILVER_HELMET.get(), (class_1935)IafItems.SILVER_CHESTPLATE.get(), (class_1935)IafItems.SILVER_LEGGINGS.get(), (class_1935)IafItems.SILVER_BOOTS.get()});
        for (DragonColor armor : IafRegistries.DRAGON_COLOR) {
            IArmorRendererBase.register((IArmorRendererBase)new ScaleArmorRenderer(), (class_1935[])new class_1935[]{(class_1935)armor.helmet.get(), (class_1935)armor.chestplate.get(), (class_1935)armor.leggings.get(), (class_1935)armor.boots.get()});
        }
        for (SeaSerpentType seaSerpent : IafRegistries.SEA_SERPENT_TYPE) {
            IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)SeaSerpentArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)seaSerpent.helmet.get(), (class_1935)seaSerpent.chestplate.get(), (class_1935)seaSerpent.leggings.get(), (class_1935)seaSerpent.boots.get()});
        }
        for (TrollType troll : IafRegistries.TROLL_TYPE) {
            IArmorRendererBase.register((IArmorRendererBase)new BasicArmorRenderer((Boolean2ObjectFunction<class_572<class_1309>>)((Boolean2ObjectFunction)TrollArmorModel::new)), (class_1935[])new class_1935[]{(class_1935)troll.helmet.get(), (class_1935)troll.chestplate.get(), (class_1935)troll.leggings.get(), (class_1935)troll.boots.get()});
        }
    }

    public static void registerItemRenderers() {
        DynamicItemRenderer.RENDERERS.put((class_1792)IafItems.DEATHWORM_GAUNTLET_RED.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((class_1792)IafItems.DEATHWORM_GAUNTLET_YELLOW.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((class_1792)IafItems.DEATHWORM_GAUNTLET_WHITE.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((class_1792)IafItems.GORGON_HEAD.get(), new GorgonHeadRenderer());
        DynamicItemRenderer.RENDERERS.put((class_1792)IafItems.TIDE_TRIDENT.get(), new TideTridentItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_BIRCH.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_OAK.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_SPRUCE.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.DREAD_PORTAL.get()).method_8389(), new MiscItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((class_2248)IafBlocks.GHOST_CHEST.get()).method_8389(), new MiscItemRenderer());
        for (TrollType.BuiltinWeapon weapon : TrollType.BuiltinWeapon.values()) {
            DynamicItemRenderer.RENDERERS.put(weapon.getItem(), new TrollWeaponRenderer());
        }
    }

    public static void registerRenderLayers() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.GOLD_PILE.get(), (class_2248)IafBlocks.SILVER_PILE.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.LECTERN.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.PODIUM_OAK.get(), (class_2248)IafBlocks.PODIUM_BIRCH.get(), (class_2248)IafBlocks.PODIUM_SPRUCE.get(), (class_2248)IafBlocks.PODIUM_JUNGLE.get(), (class_2248)IafBlocks.PODIUM_ACACIA.get(), (class_2248)IafBlocks.PODIUM_DARK_OAK.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.FIRE_LILY.get(), (class_2248)IafBlocks.FROST_LILY.get(), (class_2248)IafBlocks.LIGHTNING_LILY.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DRAGON_ICE_SPIKES.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DREAD_STONE_FACE.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.EGG_IN_ICE.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.JAR_EMPTY.get(), (class_2248)IafBlocks.JAR_PIXIE_0.get(), (class_2248)IafBlocks.JAR_PIXIE_1.get(), (class_2248)IafBlocks.JAR_PIXIE_2.get(), (class_2248)IafBlocks.JAR_PIXIE_3.get(), (class_2248)IafBlocks.JAR_PIXIE_4.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get(), (class_2248)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get(), (class_2248)IafBlocks.PIXIE_HOUSE_OAK.get(), (class_2248)IafBlocks.PIXIE_HOUSE_BIRCH.get(), (class_2248)IafBlocks.PIXIE_HOUSE_SPRUCE.get(), (class_2248)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DREAD_SPAWNER.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DREAD_TORCH.get(), (class_2248)IafBlocks.BURNT_TORCH.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DREAD_TORCH_WALL.get(), (class_2248)IafBlocks.BURNT_TORCH_WALL.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)IafBlocks.DREADWOOD_LEAVES.get(), (class_2248)IafBlocks.DREADWOOD_SAPLING.get()});
    }

    public static void registerModelPredicates() {
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.DRAGON_BOW.get()), (class_2960)class_2960.method_60656((String)"pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.DRAGON_BOW.get()), (class_2960)class_2960.method_60656((String)"pull"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity == null ? 0.0f : (livingEntity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935(livingEntity) - livingEntity.method_6014()) / 20.0f));
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.DRAGON_HORN.get()), (class_2960)class_2960.method_60656((String)"iceorfire"), (stack, level, entity, p) -> (float)DragonHornItem.getDragonType(stack) * 0.25f);
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.SUMMONING_CRYSTAL_FIRE.get()), (class_2960)class_2960.method_60656((String)"has_dragon"), (stack, level, entity, p) -> SummoningCrystalItem.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.SUMMONING_CRYSTAL_ICE.get()), (class_2960)class_2960.method_60656((String)"has_dragon"), (stack, level, entity, p) -> SummoningCrystalItem.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.SUMMONING_CRYSTAL_LIGHTNING.get()), (class_2960)class_2960.method_60656((String)"has_dragon"), (stack, level, entity, p) -> SummoningCrystalItem.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((class_1935)((class_1935)IafItems.TIDE_TRIDENT.get()), (class_2960)class_2960.method_60656((String)"throwing"), (stack, level, entity, p) -> entity != null && entity.method_6115() && entity.method_6047() == stack ? 1.0f : 0.0f);
    }
}

