/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.DragonSkullEntity;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonSize;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.registry.IafRenderers;
import com.iafenvoy.iceandfire.render.model.animator.FireDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.LightningTabulaDragonAnimator;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.iafenvoy.uranus.event.Event;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class DragonSkullEntityRenderer
extends class_897<DragonSkullEntity> {
    public static final Event<Consumer<BiConsumer<DragonType, class_3545<class_2960, MemorizeSupplier<ITabulaModelAnimator<? extends DragonBaseEntity>>>>>> COLLECT_DRAGON_SKULL_MODELS = new Event(callbacks -> consumer -> callbacks.forEach(x -> x.accept(consumer)));
    private final Map<DragonType, class_3545<class_2960, MemorizeSupplier<ITabulaModelAnimator<? extends DragonBaseEntity>>>> models = new HashMap<DragonType, class_3545<class_2960, MemorizeSupplier<ITabulaModelAnimator<? extends DragonBaseEntity>>>>();

    public DragonSkullEntityRenderer(class_5617.class_5618 context) {
        super(context);
        ((Consumer)COLLECT_DRAGON_SKULL_MODELS.invoker()).accept(this.models::put);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = 0.0f;
        cube.rotateAngleZ = 0.0f;
    }

    public void render(DragonSkullEntity entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        class_3545<class_2960, MemorizeSupplier<ITabulaModelAnimator<? extends DragonBaseEntity>>> p = this.models.get(IafRegistries.DRAGON_TYPE.method_10223(IceAndFire.id(entity.getDragonType())));
        if (p == null) {
            return;
        }
        TabulaModel model = TabulaModelHandlerHelper.getModel((class_2960)((class_2960)p.method_15442()));
        if (model == null) {
            return;
        }
        class_4588 consumer = bufferIn.getBuffer(class_1921.method_23580((class_2960)this.getTexture(entity)));
        matrixStackIn.method_22903();
        matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        matrixStackIn.method_22907(class_7833.field_40715.rotationDegrees(-180.0f - entity.method_36454()));
        matrixStackIn.method_22905(1.0f, 1.0f, 1.0f);
        float size = this.getRenderSize(entity) / 3.0f;
        matrixStackIn.method_22905(size, size, size);
        matrixStackIn.method_46416(0.0f, entity.isOnWall() ? -0.24f : -0.12f, entity.isOnWall() ? 0.4f : 0.5f);
        model.resetToDefaultPose();
        DragonSkullEntityRenderer.setRotationAngles((BasicModelPart)model.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f);
        model.getCube("Head").render(matrixStackIn, consumer, packedLightIn, class_4608.field_21444, -1);
        matrixStackIn.method_22909();
    }

    public class_2960 getTexture(DragonSkullEntity entity) {
        return ((DragonType)IafRegistries.DRAGON_TYPE.method_10223(IceAndFire.id(entity.getDragonType()))).getSkeletonTexture(entity.getDragonStage());
    }

    public float getRenderSize(DragonSkullEntity skull) {
        DragonSize size = DragonSize.getSize(skull.getDragonStage());
        float step = size.step() / 25.0f;
        if (skull.getDragonAge() > 125) {
            return size.x0() + step * 25.0f;
        }
        return size.x0() + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(DragonSkullEntity skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }

    static {
        COLLECT_DRAGON_SKULL_MODELS.register(consumer -> {
            consumer.accept(IafDragonTypes.FIRE, new class_3545((Object)IafRenderers.FIRE_DRAGON, (Object)new MemorizeSupplier(FireDragonTabulaModelAnimator::new)));
            consumer.accept(IafDragonTypes.ICE, new class_3545((Object)IafRenderers.ICE_DRAGON, (Object)new MemorizeSupplier(IceDragonTabulaModelAnimator::new)));
            consumer.accept(IafDragonTypes.LIGHTNING, new class_3545((Object)IafRenderers.LIGHTNING_DRAGON, (Object)new MemorizeSupplier(LightningTabulaDragonAnimator::new)));
        });
    }
}

