/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.animator;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.render.model.animator.IceAndFireTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.util.DragonPoses;
import com.iafenvoy.iceandfire.render.model.util.IEnumDragonModelTypes;
import com.iafenvoy.iceandfire.render.model.util.IEnumDragonPoses;
import com.iafenvoy.iceandfire.render.model.util.LegArticulator;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ITabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public abstract class DragonTabulaModelAnimator<T extends DragonBaseEntity>
extends IceAndFireTabulaModelAnimator<T>
implements ITabulaModelAnimator<T> {
    private final Map<DragonPoses, TabulaModel<T>> modelCache = new LinkedHashMap<DragonPoses, TabulaModel<T>>();
    protected final IEnumDragonModelTypes modelType;
    protected TabulaModel<T>[] walkPoses;
    protected TabulaModel<T>[] flyPoses;
    protected TabulaModel<T>[] swimPoses;
    protected AdvancedModelBox[] neckParts;
    protected AdvancedModelBox[] tailParts;
    protected AdvancedModelBox[] tailPartsWBody;
    protected AdvancedModelBox[] toesPartsL;
    protected AdvancedModelBox[] toesPartsR;
    protected AdvancedModelBox[] clawL;
    protected AdvancedModelBox[] clawR;

    public DragonTabulaModelAnimator(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        super(TabulaModelHandlerHelper.getModel((class_2960)DragonTabulaModelAnimator.buildId(pose, modelType)));
        this.modelType = modelType;
    }

    public static class_2960 buildId(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        return class_2960.method_60655((String)"iceandfire", (String)(modelType.getModelType() + "dragon/" + modelType.getModelType() + "dragon_" + pose.getPose()));
    }

    public void init(TabulaModel<T> model) {
        this.neckParts = new AdvancedModelBox[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelBox[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelBox[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelBox[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelBox[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        this.clawL = new AdvancedModelBox[]{model.getCube("ClawL")};
        this.clawR = new AdvancedModelBox[]{model.getCube("ClawR")};
    }

    public void setRotationAngles(TabulaModel<T> model, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        TabulaModel<T> currentPosition;
        int prevIndex;
        int currentIndex;
        model.resetToDefaultPose();
        if (this.neckParts == null) {
            this.init(model);
        }
        this.animate(model, (DragonBaseEntity)entity);
        boolean walking = !((DragonBaseEntity)entity).isHovering() && !((DragonBaseEntity)entity).isFlying() && ((DragonBaseEntity)entity).hoverProgress <= 0.0f && ((DragonBaseEntity)entity).flyProgress <= 0.0f;
        boolean swimming = ((DragonBaseEntity)entity).method_5799() && ((DragonBaseEntity)entity).swimProgress > 0.0f;
        int n = currentIndex = walking ? ((DragonBaseEntity)entity).walkCycle / 10 : ((DragonBaseEntity)entity).flightCycle / 10;
        if (swimming) {
            currentIndex = ((DragonBaseEntity)entity).swimCycle / 10;
        }
        if ((prevIndex = currentIndex - 1) < 0) {
            int n2 = swimming ? 4 : (prevIndex = walking ? 3 : 5);
        }
        TabulaModel<T> tabulaModel = swimming ? this.swimPoses[currentIndex] : (currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex]);
        TabulaModel<T> prevPosition = swimming ? this.swimPoses[prevIndex] : (walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex]);
        float delta = (float)(walking ? ((DragonBaseEntity)entity).walkCycle : ((DragonBaseEntity)entity).flightCycle) / 10.0f % 1.0f;
        if (swimming) {
            delta = (float)((DragonBaseEntity)entity).swimCycle / 10.0f % 1.0f;
        }
        float partialTick = class_310.method_1551().method_60646().method_60637(false);
        float deltaTicks = delta + partialTick / 10.0f;
        if (delta == 0.0f) {
            deltaTicks = 0.0f;
        }
        float speed_walk = 0.2f;
        float speed_idle = ((DragonBaseEntity)entity).method_6113() ? 0.025f : 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = ((DragonBaseEntity)entity).method_6113() ? 0.25f : 0.5f;
        float degree_fly = 0.5f;
        if (((DragonBaseEntity)entity).isModelDead()) {
            for (AdvancedModelBox cube : model.getCubes().values()) {
                this.setRotationsLoopDeath((DragonBaseEntity)entity, partialTick, cube);
            }
            return;
        }
        if (((DragonBaseEntity)entity).method_5987()) {
            return;
        }
        for (AdvancedModelBox cube : model.getCubes().values()) {
            this.setRotationsLoop(model, entity, limbSwingAmount, walking, currentPosition, prevPosition, partialTick, deltaTicks, cube);
        }
        if (((DragonBaseEntity)entity).getAnimation() != DragonBaseEntity.ANIMATION_SHAKEPREY || ((DragonBaseEntity)entity).getAnimation() != DragonBaseEntity.ANIMATION_ROAR) {
            model.faceTarget(rotationYaw, rotationPitch, 2.0f, this.neckParts);
        }
        if (!walking) {
            model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
            model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
            model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
            model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
            model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
        } else {
            model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
            model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
            model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
            model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
            model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
            model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f, -2.0, ageInTicks, 1.0f);
            model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
            model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        }
        model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
        if (((DragonBaseEntity)entity).isActuallyBreathingFire()) {
            float speed_shake = 0.7f;
            float degree_shake = 0.1f;
            model.chainFlap(this.neckParts, speed_shake, degree_shake, 2.0, ageInTicks, 1.0f);
            model.chainSwing(this.neckParts, speed_shake * 0.65f, degree_shake * 0.1f, 1.0, ageInTicks, 1.0f);
        }
        if (((DragonBaseEntity)entity).turn_buffer != null && !entity.method_5782() && !entity.method_5765() && ((DragonBaseEntity)entity).isBreathingFire()) {
            ((DragonBaseEntity)entity).turn_buffer.applyChainSwingBuffer((BasicModelPart[])this.neckParts);
        }
        if (((DragonBaseEntity)entity).tail_buffer != null && !entity.method_5765()) {
            ((DragonBaseEntity)entity).tail_buffer.applyChainSwingBuffer((BasicModelPart[])this.tailPartsWBody);
        }
        if (((DragonBaseEntity)entity).roll_buffer != null && ((DragonBaseEntity)entity).pitch_buffer_body != null && ((DragonBaseEntity)entity).pitch_buffer != null && (((DragonBaseEntity)entity).flyProgress > 0.0f || ((DragonBaseEntity)entity).hoverProgress > 0.0f)) {
            ((DragonBaseEntity)entity).roll_buffer.applyChainFlapBuffer(new BasicModelPart[]{model.getCube("BodyUpper")});
            ((DragonBaseEntity)entity).pitch_buffer_body.applyChainWaveBuffer(new BasicModelPart[]{model.getCube("BodyUpper")});
            ((DragonBaseEntity)entity).pitch_buffer.applyChainWaveBufferReverse((BasicModelPart[])this.tailPartsWBody);
        }
        if (entity.method_17681() >= 2.0f && ((DragonBaseEntity)entity).flyProgress == 0.0f && ((DragonBaseEntity)entity).hoverProgress == 0.0f) {
            LegArticulator.articulateQuadruped(entity, ((DragonBaseEntity)entity).legSolver, model.getCube("BodyUpper"), model.getCube("BodyLower"), model.getCube("Neck1"), model.getCube("ThighL"), model.getCube("LegL"), this.toesPartsL, model.getCube("ThighR"), model.getCube("LegR"), this.toesPartsR, model.getCube("armL1"), model.getCube("armL2"), this.clawL, model.getCube("armR1"), model.getCube("armR2"), this.clawR, 1.0f, 0.5f, 0.5f, -0.15f, -0.15f, 0.0f, class_310.method_1551().method_60646().method_60637(false));
        }
    }

    private void setRotationsLoop(TabulaModel<T> model, T entity, float limbSwingAmount, boolean walking, TabulaModel<T> currentPosition, TabulaModel<T> prevPosition, float partialTick, float deltaTicks, AdvancedModelBox cube) {
        float z;
        float y;
        float x;
        float prevZ;
        float prevY;
        float prevX;
        AdvancedModelBox currPositionCube;
        AdvancedModelBox prevPositionCube;
        this.genderMob(entity, cube);
        if (walking && ((DragonBaseEntity)entity).flyProgress <= 0.0f && ((DragonBaseEntity)entity).hoverProgress <= 0.0f && ((DragonBaseEntity)entity).modelDeadProgress <= 0.0f) {
            AdvancedModelBox walkPart = this.getModel(DragonPoses.GROUND_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            currPositionCube = currentPosition.getCube(cube.boxName);
            if (prevPositionCube == null || currPositionCube == null) {
                return;
            }
            prevX = prevPositionCube.rotateAngleX;
            prevY = prevPositionCube.rotateAngleY;
            prevZ = prevPositionCube.rotateAngleZ;
            x = currPositionCube.rotateAngleX;
            y = currPositionCube.rotateAngleY;
            z = currPositionCube.rotateAngleZ;
            if (this.isHorn(cube) || this.isWing(model, cube) && (((DragonBaseEntity)entity).getAnimation() == DragonBaseEntity.ANIMATION_WINGBLAST || ((DragonBaseEntity)entity).getAnimation() == DragonBaseEntity.ANIMATION_EPIC_ROAR)) {
                this.addToRotateAngle(cube, limbSwingAmount, walkPart.rotateAngleX, walkPart.rotateAngleY, walkPart.rotateAngleZ);
            } else {
                this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
        if (((DragonBaseEntity)entity).sleepProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(DragonPoses.SLEEPING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(DragonPoses.SLEEPING_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[1], (float)((DragonBaseEntity)entity).sleepProgress), 20.0f, false);
        }
        if (((DragonBaseEntity)entity).hoverProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(DragonPoses.HOVERING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Tail")) {
            this.transitionTo(cube, this.getModel(DragonPoses.HOVERING_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[2], (float)((DragonBaseEntity)entity).hoverProgress), 20.0f, false);
        }
        if (((DragonBaseEntity)entity).flyProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(DragonPoses.FLYING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(DragonPoses.FLYING_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[3], (float)((DragonBaseEntity)entity).flyProgress) - class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevDiveProgress, (float)((DragonBaseEntity)entity).diveProgress) * 2.0f, 20.0f, false);
        }
        if (((DragonBaseEntity)entity).sitProgress > 0.0f && !entity.method_5765() && !this.isRotationEqual(cube, this.getModel(DragonPoses.SITTING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(DragonPoses.SITTING_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[0], (float)((DragonBaseEntity)entity).sitProgress), 20.0f, false);
        }
        if (((DragonBaseEntity)entity).ridingProgress > 0.0f && !this.isHorn(cube) && !this.isRotationEqual(cube, this.getModel(DragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(DragonPoses.SIT_ON_PLAYER_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[5], (float)((DragonBaseEntity)entity).ridingProgress), 20.0f, false);
            if (cube.boxName.equals("BodyUpper")) {
                cube.offsetZ += (-12.0f - cube.offsetZ) / 20.0f * class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[5], (float)((DragonBaseEntity)entity).ridingProgress);
            }
        }
        if (((DragonBaseEntity)entity).tackleProgress > 0.0f && !this.isRotationEqual(this.getModel(DragonPoses.TACKLE).getCube(cube.boxName), this.getModel(DragonPoses.FLYING_POSE).getCube(cube.boxName)) && !this.isWing(model, cube)) {
            this.transitionTo(cube, this.getModel(DragonPoses.TACKLE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevAnimationProgresses[6], (float)((DragonBaseEntity)entity).tackleProgress), 5.0f, false);
        }
        if (((DragonBaseEntity)entity).diveProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(DragonPoses.DIVING_POSE).getCube(cube.boxName))) {
            this.transitionTo(cube, this.getModel(DragonPoses.DIVING_POSE).getCube(cube.boxName), class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevDiveProgress, (float)((DragonBaseEntity)entity).diveProgress), 10.0f, false);
        }
        if (((DragonBaseEntity)entity).fireBreathProgress > 0.0f && !this.isRotationEqual(cube, this.getModel(DragonPoses.STREAM_BREATH).getCube(cube.boxName)) && !this.isWing(model, cube) && !cube.boxName.contains("Finger")) {
            if (((DragonBaseEntity)entity).prevFireBreathProgress <= ((DragonBaseEntity)entity).fireBreathProgress) {
                this.transitionTo(cube, this.getModel(DragonPoses.BLAST_CHARGE3).getCube(cube.boxName), class_3532.method_15363((float)class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevFireBreathProgress, (float)((DragonBaseEntity)entity).fireBreathProgress), (float)0.0f, (float)5.0f), 5.0f, false);
            }
            this.transitionTo(cube, this.getModel(DragonPoses.STREAM_BREATH).getCube(cube.boxName), class_3532.method_15363((float)(class_3532.method_16439((float)partialTick, (float)((DragonBaseEntity)entity).prevFireBreathProgress, (float)((DragonBaseEntity)entity).fireBreathProgress) - 5.0f), (float)0.0f, (float)5.0f), 5.0f, false);
        }
        if (!walking) {
            AdvancedModelBox flightPart = this.getModel(DragonPoses.FLYING_POSE).getCube(cube.boxName);
            prevPositionCube = prevPosition.getCube(cube.boxName);
            currPositionCube = currentPosition.getCube(cube.boxName);
            prevX = prevPositionCube.rotateAngleX;
            prevY = prevPositionCube.rotateAngleY;
            prevZ = prevPositionCube.rotateAngleZ;
            x = currPositionCube.rotateAngleX;
            y = currPositionCube.rotateAngleY;
            z = currPositionCube.rotateAngleZ;
            if (x != flightPart.rotateAngleX || y != flightPart.rotateAngleY || z != flightPart.rotateAngleZ) {
                this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
            }
        }
    }

    public void setRotationsLoopDeath(DragonBaseEntity entity, float partialTick, AdvancedModelBox cube) {
        if (entity.modelDeadProgress > 0.0f) {
            TabulaModel<T> pose = this.getModel(DragonPoses.DEAD);
            if (!this.isRotationEqual(cube, pose.getCube(cube.boxName))) {
                this.transitionTo(cube, pose.getCube(cube.boxName), entity.prevModelDeadProgress + (entity.modelDeadProgress - entity.prevModelDeadProgress) * class_310.method_1551().method_60646().method_60637(false), 20.0f, cube.boxName.equals("ThighR") || cube.boxName.equals("ThighL"));
            }
            if (this instanceof IceDragonTabulaModelAnimator && cube.boxName.equals("BodyUpper")) {
                cube.rotationPointY += 0.35f * class_3532.method_16439((float)partialTick, (float)entity.prevModelDeadProgress, (float)entity.modelDeadProgress);
            }
        }
    }

    protected boolean isWing(TabulaModel<T> model, AdvancedModelBox modelRenderer) {
        return model.getCube("armL1") == modelRenderer || model.getCube("armR1") == modelRenderer || model.getCube((String)"armL1").childModels.contains((Object)modelRenderer) || model.getCube((String)"armR1").childModels.contains((Object)modelRenderer);
    }

    protected boolean isHorn(AdvancedModelBox modelRenderer) {
        return modelRenderer.boxName.contains("Horn");
    }

    protected void genderMob(T entity, AdvancedModelBox cube) {
        if (!((DragonBaseEntity)entity).isMale()) {
            TabulaModel<T> maleModel = this.getModel(DragonPoses.MALE);
            TabulaModel<T> femaleModel = this.getModel(DragonPoses.FEMALE);
            AdvancedModelBox femaleModelCube = femaleModel.getCube(cube.boxName);
            AdvancedModelBox maleModelCube = maleModel.getCube(cube.boxName);
            if (maleModelCube == null || femaleModelCube == null) {
                return;
            }
            float x = femaleModelCube.rotateAngleX;
            float y = femaleModelCube.rotateAngleY;
            float z = femaleModelCube.rotateAngleZ;
            if (x != maleModelCube.rotateAngleX || y != maleModelCube.rotateAngleY || z != maleModelCube.rotateAngleZ) {
                this.setRotateAngle(cube, 1.0f, x, y, z);
            }
        }
    }

    protected TabulaModel<T> getModel(DragonPoses pose) {
        if (this.modelCache.containsKey(pose)) {
            return this.modelCache.get(pose);
        }
        TabulaModel model = TabulaModelHandlerHelper.getModel((class_2960)DragonTabulaModelAnimator.buildId(pose, this.modelType));
        this.modelCache.put(pose, model);
        return model;
    }

    protected void animate(TabulaModel<T> model, DragonBaseEntity entity) {
        AdvancedModelBox modelCubeJaw = model.getCube("Jaw");
        AdvancedModelBox modelCubeBodyUpper = model.getCube("BodyUpper");
        model.animator.startAnimate((IAnimatedEntity)entity);
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_FIRECHARGE)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.BLAST_CHARGE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.BLAST_CHARGE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.BLAST_CHARGE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(5);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_SPEAK)) {
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(5);
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(5);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_BITE)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.BITE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.BITE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.BITE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_SHAKEPREY)) {
            model.animator.startKeyframe(15);
            this.moveToPose(model, this.getModel(DragonPoses.GRAB1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.GRAB2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.GRAB_SHAKE1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.GRAB_SHAKE2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.GRAB_SHAKE3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_TAILWHACK)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.TAIL_WHIP1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.TAIL_WHIP2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.TAIL_WHIP3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_WINGBLAST)) {
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST1));
            model.animator.move(modelCubeBodyUpper, 0.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST2));
            model.animator.move(modelCubeBodyUpper, 0.0f, -2.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST3));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST4));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST5));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST6));
            model.animator.move(modelCubeBodyUpper, 0.0f, -4.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.moveToPose(model, this.getModel(DragonPoses.WING_BLAST7));
            model.animator.move(modelCubeBodyUpper, 0.0f, -2.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_ROAR)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.ROAR1));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.ROAR2));
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.ROAR3));
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_EPIC_ROAR)) {
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.EPIC_ROAR1));
            model.animator.rotate(modelCubeBodyUpper, -0.1f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.EPIC_ROAR2));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.EPIC_ROAR3));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.EPIC_ROAR2));
            model.animator.rotate(modelCubeBodyUpper, -0.2f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(10);
            this.moveToPose(model, this.getModel(DragonPoses.EPIC_ROAR3));
            model.animator.rotate(modelCubeBodyUpper, -0.1f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.resetKeyframe(10);
        }
        if (model.animator.setAnimation(DragonBaseEntity.ANIMATION_EAT)) {
            model.animator.startKeyframe(5);
            this.rotate(model.animator, model.getCube("Neck1"), 18.0f, 0.0f, 0.0f);
            this.rotate(model.animator, model.getCube("Neck2"), 18.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.setStaticKeyframe(5);
            model.animator.startKeyframe(5);
            this.rotate(model.animator, modelCubeJaw, 18.0f, 0.0f, 0.0f);
            model.animator.move(modelCubeJaw, 0.0f, 0.0f, 0.2f);
            model.animator.endKeyframe();
            model.animator.startKeyframe(5);
            this.rotate(model.animator, model.getCube("Neck1"), -18.0f, 0.0f, 0.0f);
            this.rotate(model.animator, model.getCube("Neck2"), -18.0f, 0.0f, 0.0f);
            model.animator.endKeyframe();
        }
        model.animator.endAnimate();
    }
}

