/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.util;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(DragonBaseEntity entity, float scale) {
        this.update(entity, entity.field_6283, scale);
    }

    public final void update(DragonBaseEntity entity, float yaw, float scale) {
        double sideTheta = (double)yaw / 57.29577951308232;
        double sideX = class_3532.method_15362((float)((float)sideTheta)) * scale;
        double sideZ = class_3532.method_15374((float)((float)sideTheta)) * scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = class_3532.method_15362((float)((float)forwardTheta)) * scale;
        double forwardZ = class_3532.method_15374((float)((float)forwardTheta)) * scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range, boolean isWing) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(DragonBaseEntity entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double posY = entity.method_23318();
            float settledHeight = this.settle(entity, entity.method_23317() + sideX * (double)this.side + forwardX * (double)this.forward, posY, entity.method_23321() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
            this.height = class_3532.method_15363((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(DragonBaseEntity entity, double x, double y, double z, float height) {
            class_2338 pos = class_2338.method_49637((double)x, (double)(y + 0.001), (double)z);
            float dist = this.getDistance(entity.method_37908(), pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.method_37908(), pos.method_10074()) + (float)y % 1.0f : (dist -= (float)(1.0 - y % 1.0));
            if (entity.method_24828() && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        private float getDistance(class_1937 world, class_2338 pos) {
            class_2680 state = world.method_8320(pos);
            class_265 aabb = state.method_26220((class_1922)world, pos);
            return aabb.method_1110() ? 1.0f : 1.0f - Math.min((float)aabb.method_1102(class_2350.class_2351.field_11052, 0.5, 0.5), 1.0f);
        }

        private float getFallSpeed() {
            return 0.25f;
        }

        private float getRiseSpeed() {
            return 0.25f;
        }
    }
}

