/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonBlockTags;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.structure.DragonRoostStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3773;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class FireDragonRoostStructure
extends DragonRoostStructure {
    public static final MapCodec<FireDragonRoostStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FireDragonRoostStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, FireDragonRoostStructure::new));

    protected FireDragonRoostStructure(class_3195.class_7302 config) {
        super(config);
    }

    @Override
    protected DragonRoostStructure.DragonRoostPiece createPiece(class_3341 boundingBox, boolean isMale) {
        return new FireDragonRoostPiece(0, boundingBox, (class_2248)IafBlocks.GOLD_PILE.get(), isMale);
    }

    @Override
    protected double getGenerateChance() {
        return (Double)IafCommonConfig.INSTANCE.worldGen.generateFireDragonRoostChance.getValue();
    }

    public class_7151<?> method_41618() {
        return (class_7151)IafStructureTypes.FIRE_DRAGON_ROOST.get();
    }

    public static class FireDragonRoostPiece
    extends DragonRoostStructure.DragonRoostPiece {
        private static final class_2960 DRAGON_CHEST = class_2960.method_60655((String)"iceandfire", (String)"chest/fire_dragon_roost");

        protected FireDragonRoostPiece(int length, class_3341 boundingBox, class_2248 treasureBlock, boolean isMale) {
            super((class_3773)IafStructurePieces.FIRE_DRAGON_ROOST.get(), length, boundingBox, treasureBlock, isMale);
        }

        public FireDragonRoostPiece(class_6625 context, class_2487 nbt) {
            super((class_3773)IafStructurePieces.FIRE_DRAGON_ROOST.get(), nbt);
        }

        @Override
        protected class_1299<? extends DragonBaseEntity> getDragonType() {
            return (class_1299)IafEntities.FIRE_DRAGON.get();
        }

        @Override
        protected class_5321<class_52> getRoostLootTable() {
            return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)DRAGON_CHEST);
        }

        @Override
        protected class_2680 transform(class_2680 state) {
            class_2248 block = null;
            if (state.method_27852(class_2246.field_10219)) {
                block = (class_2248)IafBlocks.CHARRED_GRASS.get();
            } else if (state.method_27852(class_2246.field_10194)) {
                block = (class_2248)IafBlocks.CHARRED_DIRT_PATH.get();
            } else if (state.method_26164(CommonBlockTags.GRAVELS)) {
                block = (class_2248)IafBlocks.CHARRED_GRAVEL.get();
            } else if (state.method_26164(class_3481.field_29822)) {
                block = (class_2248)IafBlocks.CHARRED_DIRT.get();
            } else if (state.method_26164(CommonBlockTags.STONES)) {
                block = (class_2248)IafBlocks.CHARRED_STONE.get();
            } else if (state.method_26164(CommonBlockTags.COBBLESTONES)) {
                block = (class_2248)IafBlocks.CHARRED_COBBLESTONE.get();
            } else if (state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15471)) {
                block = (class_2248)IafBlocks.ASH.get();
            } else if (state.method_26164(IafBlockTags.GRASSES) || state.method_26164(class_3481.field_15503) || state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_20341)) {
                block = class_2246.field_10124;
            }
            if (block != null) {
                return block.method_9564();
            }
            return state;
        }

        @Override
        protected void handleCustomGeneration(class_5281 world, class_2338 origin, class_5819 random, class_2338 position, double distance) {
            if (random.method_43048(1000) == 0) {
                this.generateRoostPile(world, random, this.getSurfacePosition(world, position), (class_2248)IafBlocks.ASH.get());
            }
        }
    }
}

