/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.DreadMobEntity;
import com.iafenvoy.iceandfire.entity.ai.DreadAITargetNonDreadGoal;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IHasArmorVariant;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DreadThrallEntity
extends DreadMobEntity
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHasArmorVariant {
    public static final Animation ANIMATION_SPAWN = Animation.create((int)40);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_HEAD = SynchedEntityData.defineId(DreadThrallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_CHEST = SynchedEntityData.defineId(DreadThrallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_LEGS = SynchedEntityData.defineId(DreadThrallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_FEET = SynchedEntityData.defineId(DreadThrallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> CUSTOM_ARMOR_INDEX = SynchedEntityData.defineId(DreadThrallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int animationTick;
    private Animation currentAnimation;

    public DreadThrallEntity(EntityType<? extends DreadThrallEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return DreadThrallEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IDreadMob.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)((com.google.common.base.Predicate)DragonUtils::canHostilesTarget)));
        this.targetSelector.addGoal(3, (Goal)new DreadAITargetNonDreadGoal((Mob)this, LivingEntity.class, false, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity))));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CUSTOM_ARMOR_INDEX, (Object)0);
        builder.define(CUSTOM_ARMOR_HEAD, (Object)Boolean.FALSE);
        builder.define(CUSTOM_ARMOR_CHEST, (Object)Boolean.FALSE);
        builder.define(CUSTOM_ARMOR_LEGS, (Object)Boolean.FALSE);
        builder.define(CUSTOM_ARMOR_FEET, (Object)Boolean.FALSE);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.level().getBlockState(this.blockPosition().below());
            if (belowBlock.getBlock() != Blocks.AIR) {
                for (int i = 0; i < 5; ++i) {
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, belowBlock), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getBoundingBox().minY, this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
                }
            }
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
        }
        if (this.getMainHandItem().getItem() == Items.BOW) {
            this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BONE));
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(randomSource, difficulty);
        if (this.random.nextFloat() < 0.75f) {
            double chance = this.random.nextFloat();
            if (chance < (double)0.0025f) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.DRAGONSTEEL_ICE_SWORD.get()));
            }
            if (chance < (double)0.01f) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.DIAMOND_SWORD));
            }
            if (chance < (double)0.1f) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            }
            if (chance < 0.75) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.DREAD_SWORD.get()));
            }
        }
        if (this.random.nextFloat() < 0.75f) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.CHAINMAIL_HELMET));
            this.setCustomArmorHead(this.random.nextInt(8) != 0);
        }
        if (this.random.nextFloat() < 0.75f) {
            this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE));
            this.setCustomArmorChest(this.random.nextInt(8) != 0);
        }
        if (this.random.nextFloat() < 0.75f) {
            this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS));
            this.setCustomArmorLegs(this.random.nextInt(8) != 0);
        }
        if (this.random.nextFloat() < 0.75f) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS));
            this.setCustomArmorFeet(this.random.nextInt(8) != 0);
        }
        this.setBodyArmorVariant(this.random.nextInt(8));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setAnimation(ANIMATION_SPAWN);
        this.populateDefaultEquipmentSlots(worldIn.getRandom(), difficultyIn);
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("ArmorVariant", this.getBodyArmorVariant());
        compound.putBoolean("HasCustomHelmet", this.hasCustomArmorHead());
        compound.putBoolean("HasCustomChestplate", this.hasCustomArmorChest());
        compound.putBoolean("HasCustomLeggings", this.hasCustomArmorLegs());
        compound.putBoolean("HasCustomBoots", this.hasCustomArmorFeet());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBodyArmorVariant(compound.getInt("ArmorVariant"));
        this.setCustomArmorHead(compound.getBoolean("HasCustomHelmet"));
        this.setCustomArmorChest(compound.getBoolean("HasCustomChestplate"));
        this.setCustomArmorLegs(compound.getBoolean("HasCustomLeggings"));
        this.setCustomArmorFeet(compound.getBoolean("HasCustomBoots"));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean hasCustomArmorHead() {
        return (Boolean)this.entityData.get(CUSTOM_ARMOR_HEAD);
    }

    public void setCustomArmorHead(boolean head) {
        this.entityData.set(CUSTOM_ARMOR_HEAD, (Object)head);
    }

    public boolean hasCustomArmorChest() {
        return (Boolean)this.entityData.get(CUSTOM_ARMOR_CHEST);
    }

    public void setCustomArmorChest(boolean head) {
        this.entityData.set(CUSTOM_ARMOR_CHEST, (Object)head);
    }

    public boolean hasCustomArmorLegs() {
        return (Boolean)this.entityData.get(CUSTOM_ARMOR_LEGS);
    }

    public void setCustomArmorLegs(boolean head) {
        this.entityData.set(CUSTOM_ARMOR_LEGS, (Object)head);
    }

    public boolean hasCustomArmorFeet() {
        return (Boolean)this.entityData.get(CUSTOM_ARMOR_FEET);
    }

    public void setCustomArmorFeet(boolean head) {
        this.entityData.set(CUSTOM_ARMOR_FEET, (Object)head);
    }

    @Override
    public int getBodyArmorVariant() {
        return (Integer)this.entityData.get(CUSTOM_ARMOR_INDEX);
    }

    @Override
    public void setBodyArmorVariant(int variant) {
        this.entityData.set(CUSTOM_ARMOR_INDEX, (Object)variant);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.STRAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.STRAY_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.STRAY_STEP, 0.15f, 1.0f);
    }
}

