/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.StoneStatueEntity;
import com.iafenvoy.iceandfire.entity.ai.GorgonAIStareAttackGoal;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GorgonEntity
extends Monster
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid,
IHasCustomizableAttributes {
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;
    private GorgonAIStareAttackGoal aiStare;
    private MeleeAttackGoal aiMelee;
    private int playerStatueCooldown;

    public GorgonEntity(EntityType<GorgonEntity> type, Level worldIn) {
        super(type, worldIn);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
    }

    public static boolean isStoneMob(LivingEntity mob) {
        return mob instanceof StoneStatueEntity;
    }

    public static boolean isBlindfolded(LivingEntity attackTarget) {
        if (attackTarget == null) {
            return false;
        }
        if (attackTarget.getItemBySlot(EquipmentSlot.HEAD).getItem() == IafItems.BLINDFOLD.get() || attackTarget.hasEffect(MobEffects.BLINDNESS)) {
            return true;
        }
        return attackTarget.getType().is(IafEntityTags.BLINDED);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)IafCommonConfig.INSTANCE.gorgon.maxHealth.getValue()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 1.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)IafCommonConfig.INSTANCE.gorgon.maxHealth.getValue()).doubleValue());
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        BlockHitResult result = this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.getType() != HitResult.Type.MISS;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.aiStare = new GorgonAIStareAttackGoal(this, 1.0, 0, 15.0f);
        this.goalSelector.addGoal(3, (Goal)this.aiStare);
        this.aiMelee = new MeleeAttackGoal((PathfinderMob)this, 1.0, false);
        this.goalSelector.addGoal(3, (Goal)this.aiMelee);
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal(this, (PathfinderMob)this, 1.0){

            public boolean canUse() {
                this.interval = 20;
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 8.0f, 1.0f){

            public boolean canContinueToUse() {
                if (this.lookAt != null && this.lookAt instanceof Player && ((Player)this.lookAt).isCreative()) {
                    return false;
                }
                return super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, LivingEntity::isAlive));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> {
            BlacklistedFromStatues blacklisted;
            return entity instanceof LivingEntity && DragonUtils.isAlive(entity) || entity instanceof BlacklistedFromStatues && (blacklisted = (BlacklistedFromStatues)entity).canBeTurnedToStone();
        }));
        this.goalSelector.removeGoal((Goal)this.aiMelee);
    }

    public boolean doHurtTarget(Entity entityIn) {
        BlacklistedFromStatues blacklisted;
        LivingEntity livingEntity;
        boolean blindness;
        boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || this.getTarget() != null && this.getTarget().hasEffect(MobEffects.BLINDNESS) || this.getTarget() != null && (livingEntity = this.getTarget()) instanceof BlacklistedFromStatues && !(blacklisted = (BlacklistedFromStatues)livingEntity).canBeTurnedToStone();
        if (blindness && this.deathTime == 0) {
            if (this.getAnimation() != ANIMATION_HIT) {
                this.setAnimation(ANIMATION_HIT);
            }
            if (entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 2, false, true));
            }
        }
        return super.doHurtTarget(entityIn);
    }

    public void setTarget(LivingEntity LivingEntityIn) {
        super.setTarget(LivingEntityIn);
        if (LivingEntityIn != null && !this.level().isClientSide) {
            boolean blindness;
            boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || LivingEntityIn.hasEffect(MobEffects.BLINDNESS) || LivingEntityIn instanceof BlacklistedFromStatues && !((BlacklistedFromStatues)LivingEntityIn).canBeTurnedToStone() || GorgonEntity.isBlindfolded(LivingEntityIn);
            if (blindness && this.deathTime == 0) {
                this.goalSelector.addGoal(3, (Goal)this.aiMelee);
                this.goalSelector.removeGoal((Goal)this.aiStare);
            } else {
                this.goalSelector.addGoal(3, (Goal)this.aiStare);
                this.goalSelector.removeGoal((Goal)this.aiMelee);
            }
        }
    }

    public int getBaseExperienceReward() {
        return 30;
    }

    protected void tickDeath() {
        double d1;
        double d0;
        int k;
        ++this.deathTime;
        this.ambientSoundTime = 20;
        if (this.level().isClientSide) {
            for (k = 0; k < 5; ++k) {
                double d2 = 0.4;
                d0 = 0.1;
                d1 = 0.1;
                this.level().addParticle((ParticleOptions)IafParticles.BLOOD.get(), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY(), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d2, d0, d1);
            }
        }
        if (this.deathTime >= 200) {
            if (!this.level().isClientSide && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS))) {
                int j;
                for (int i = this.getBaseExperienceReward(); i > 0; i -= j) {
                    j = ExperienceOrb.getExperienceValue((int)i);
                    this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), j));
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
            for (k = 0; k < 20; ++k) {
                double d2 = this.random.nextGaussian() * 0.02;
                d0 = this.random.nextGaussian() * 0.02;
                d1 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d2, d0, d1);
            }
        }
    }

    public void aiStep() {
        boolean blindness;
        LivingEntity attackTarget;
        super.aiStep();
        if (this.playerStatueCooldown > 0) {
            --this.playerStatueCooldown;
        }
        if ((attackTarget = this.getTarget()) != null) {
            boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || attackTarget.hasEffect(MobEffects.BLINDNESS);
            if (!blindness && this.deathTime == 0 && attackTarget instanceof Mob) {
                this.forcePreyToLook(attackTarget);
            }
            if (IafEntityUtil.isEntityLookingAt(attackTarget, (LivingEntity)this, 0.4)) {
                this.getLookControl().setLookAt(attackTarget.getX(), attackTarget.getY() + (double)attackTarget.getEyeHeight(), attackTarget.getZ(), (float)this.getMaxHeadYRot(), (float)this.getMaxHeadXRot());
            }
        }
        if (attackTarget != null && IafEntityUtil.isEntityLookingAt((LivingEntity)this, attackTarget, 0.4) && IafEntityUtil.isEntityLookingAt(attackTarget, (LivingEntity)this, 0.4) && !GorgonEntity.isBlindfolded(attackTarget)) {
            BlacklistedFromStatues blacklisted;
            boolean bl = blindness = this.hasEffect(MobEffects.BLINDNESS) || attackTarget.hasEffect(MobEffects.BLINDNESS) || attackTarget instanceof BlacklistedFromStatues && !(blacklisted = (BlacklistedFromStatues)attackTarget).canBeTurnedToStone();
            if (!blindness && this.deathTime == 0) {
                if (this.getAnimation() != ANIMATION_SCARE) {
                    this.playSound((SoundEvent)IafSounds.GORGON_ATTACK.get(), 1.0f, 1.0f);
                    this.setAnimation(ANIMATION_SCARE);
                }
                if (this.getAnimation() == ANIMATION_SCARE && this.getAnimationTick() > 10 && !this.level().isClientSide && this.playerStatueCooldown == 0) {
                    StoneStatueEntity statue = StoneStatueEntity.buildStatueEntity(attackTarget);
                    statue.absMoveTo(attackTarget.getX(), attackTarget.getY(), attackTarget.getZ(), attackTarget.getYRot(), attackTarget.getXRot());
                    if (!this.level().isClientSide) {
                        this.level().addFreshEntity((Entity)statue);
                    }
                    statue.setYRot(attackTarget.getYRot());
                    statue.setYRot(attackTarget.getYRot());
                    statue.yHeadRot = attackTarget.getYRot();
                    statue.yBodyRot = attackTarget.getYRot();
                    statue.yBodyRotO = attackTarget.getYRot();
                    this.playerStatueCooldown = 40;
                    if (attackTarget instanceof Player) {
                        attackTarget.hurt((DamageSource)IafDamageTypes.causeGorgonDamage((Entity)this), 2.1474836E9f);
                    } else {
                        attackTarget.remove(Entity.RemovalReason.KILLED);
                    }
                    this.setTarget(null);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getMaxHeadXRot() {
        return 10;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public void forcePreyToLook(LivingEntity mob) {
        if (mob instanceof Mob) {
            Mob mobEntity = (Mob)mob;
            mobEntity.getLookControl().setLookAt(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), (float)mobEntity.getMaxHeadYRot(), (float)mobEntity.getMaxHeadXRot());
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setConfigurableAttributes();
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SCARE, ANIMATION_HIT};
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.GORGON_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)IafSounds.GORGON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.GORGON_DIE.get();
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }
}

