/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.data.HippogryphType;
import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class HippogryphEggEntity
extends ThrownEgg {
    private ItemStack itemstack;

    public HippogryphEggEntity(EntityType<? extends ThrownEgg> type, Level world) {
        super(type, world);
    }

    public HippogryphEggEntity(EntityType<? extends ThrownEgg> type, Level worldIn, double x, double y, double z, ItemStack stack) {
        this(type, worldIn);
        this.setPos(x, y, z);
        this.itemstack = stack;
    }

    public HippogryphEggEntity(EntityType<? extends ThrownEgg> type, Level worldIn, LivingEntity throwerIn, ItemStack stack) {
        this(type, worldIn);
        this.setPos(throwerIn.getX(), throwerIn.getEyeY() - (double)0.1f, throwerIn.getZ());
        this.itemstack = stack;
        this.setOwner((Entity)throwerIn);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void onHit(HitResult result) {
        Level level;
        Entity thrower = this.getOwner();
        if (result instanceof EntityHitResult) {
            EntityHitResult hitResult = (EntityHitResult)result;
            hitResult.getEntity().hurt(this.level().damageSources().thrown((Entity)this, thrower), 0.0f);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            HippogryphType variant;
            ServerLevel serverWorld = (ServerLevel)level;
            HippogryphEntity hippogryph = new HippogryphEntity((EntityType<? extends TamableAnimal>)((EntityType)IafEntities.HIPPOGRYPH.get()), this.level());
            hippogryph.setAge(-24000);
            hippogryph.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            hippogryph.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.SPAWN_EGG, null);
            if (this.itemstack != null && (variant = (HippogryphType)this.itemstack.get((DataComponentType)IafDataComponents.HIPPOGRYPH_EGG.get())) != null) {
                hippogryph.setVariant(variant);
            }
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                hippogryph.tame(player);
            }
            this.level().addFreshEntity((Entity)hippogryph);
        }
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected Item getDefaultItem() {
        return (Item)IafItems.HIPPOGRYPH_EGG.get();
    }
}

