/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.CockatriceEntity;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class CockatriceAIAggroLookGoal
extends NearestAttackableTargetGoal<Player> {
    private final CockatriceEntity cockatrice;
    private final TargetingConditions predicate;
    private Player player;

    public CockatriceAIAggroLookGoal(CockatriceEntity cockatriceIn) {
        super((Mob)cockatriceIn, Player.class, false);
        this.cockatrice = cockatriceIn;
        Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = target -> IafEntityUtil.isEntityLookingAt(target, (LivingEntity)this.cockatrice, 0.6f) && (double)this.cockatrice.distanceTo((Entity)target) < this.getFollowDistance();
        this.predicate = TargetingConditions.forCombat().range(25.0).selector(LIVING_ENTITY_SELECTOR);
    }

    public boolean canUse() {
        if (this.cockatrice.isTame()) {
            return false;
        }
        this.player = this.cockatrice.level().getNearestPlayer(this.predicate, this.cockatrice.getX(), this.cockatrice.getY(), this.cockatrice.getZ());
        return this.player != null;
    }

    public void stop() {
        this.player = null;
        super.stop();
    }

    public boolean canContinueToUse() {
        if (this.player != null && !this.player.isCreative() && !this.player.isSpectator()) {
            if (!IafEntityUtil.isEntityLookingAt((LivingEntity)this.player, (LivingEntity)this.cockatrice, 0.4f)) {
                return false;
            }
            this.cockatrice.lookAt((Entity)this.player, 10.0f, 10.0f);
            if (!this.cockatrice.isTame()) {
                this.cockatrice.setTargetedEntity(this.player.getId());
                this.cockatrice.setTarget((LivingEntity)this.player);
            }
            return true;
        }
        return this.targetMob != null && this.targetMob.isAlive() || super.canContinueToUse();
    }
}

