/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;

public class DragonAILookIdleGoal
extends Goal {
    private final DragonBaseEntity dragon;
    private double lookX;
    private double lookZ;
    private int idleTime;

    public DragonAILookIdleGoal(DragonBaseEntity prehistoric) {
        this.dragon = prehistoric;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dragon.canMove() || this.dragon.getAnimation() == DragonBaseEntity.ANIMATION_SHAKEPREY || this.dragon.isFuelingForge()) {
            return false;
        }
        return this.dragon.getRandom().nextFloat() < 0.02f;
    }

    public boolean canContinueToUse() {
        return this.idleTime >= 0 && this.dragon.canMove();
    }

    public void start() {
        double d0 = Math.PI * 2 * this.dragon.getRandom().nextDouble();
        this.lookX = Mth.cos((float)((float)d0));
        this.lookZ = Mth.sin((float)((float)d0));
        this.idleTime = 20 + this.dragon.getRandom().nextInt(20);
    }

    public void tick() {
        if (this.idleTime > 0) {
            --this.idleTime;
        }
        this.dragon.getLookControl().setLookAt(this.dragon.getX() + this.lookX, this.dragon.getY() + (double)this.dragon.getEyeHeight(), this.dragon.getZ() + this.lookZ, (float)this.dragon.getMaxHeadYRot(), (float)this.dragon.getMaxHeadXRot());
    }
}

