/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItemsGoal;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.util.IafMath;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class HippogryphAITargetItemsGoal<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItemsGoal.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected final int targetChance;
    protected ItemEntity targetEntity;
    private List<ItemEntity> list = IafMath.emptyItemEntityList;

    public HippogryphAITargetItemsGoal(Mob creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public HippogryphAITargetItemsGoal(Mob creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public HippogryphAITargetItemsGoal(Mob creature, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItemsGoal.Sorter((Entity)creature);
        this.targetChance = chance;
        this.targetEntitySelector = item -> item != null && !item.getItem().isEmpty() && item.getItem().is(IafItemTags.TAME_HIPPOGRYPH);
    }

    public boolean canUse() {
        if (this.targetChance > 0 && this.mob.getRandom().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (!((HippogryphEntity)this.mob).canMove()) {
            this.list = IafMath.emptyItemEntityList;
            return false;
        }
        return this.updateList();
    }

    private boolean updateList() {
        this.list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.getTargetableArea(this.getFollowDistance()), this.targetEntitySelector);
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.getFirst();
        return true;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.mob.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
        super.start();
    }

    public void tick() {
        super.tick();
        if (this.targetEntity == null || !this.targetEntity.isAlive()) {
            this.stop();
        } else if (this.getAttackReachSqr((Entity)this.targetEntity) >= this.mob.distanceToSqr((Entity)this.targetEntity)) {
            Entity entity;
            HippogryphEntity hippo = (HippogryphEntity)this.mob;
            this.targetEntity.getItem().shrink(1);
            this.mob.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
            hippo.setAnimation(HippogryphEntity.ANIMATION_EAT);
            ++hippo.feedings;
            hippo.heal(4.0f);
            if (hippo.feedings > 3 && (hippo.feedings > 7 || hippo.getRandom().nextInt(3) == 0) && !hippo.isTame() && (entity = this.targetEntity.getOwner()) instanceof Player) {
                Player owner = (Player)entity;
                hippo.tame(owner);
                hippo.setTarget(null);
                hippo.setCommand(1);
                hippo.setOrderedToSit(true);
            }
            this.stop();
        } else {
            this.updateList();
        }
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + attackTarget.getBbWidth();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.distanceToSqr(p_compare_1_);
            double d1 = this.theEntity.distanceToSqr(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

