/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.PixieEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PixieAIMoveRandomGoal
extends Goal {
    final PixieEntity pixie;
    final RandomSource random;
    BlockPos target;

    public PixieAIMoveRandomGoal(PixieEntity pixieEntityIn) {
        this.pixie = pixieEntityIn;
        this.random = pixieEntityIn.getRandom();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.target = PixieEntity.getPositionRelativetoGround((Entity)this.pixie, this.pixie.level(), this.pixie.getX() + (double)this.random.nextInt(15) - 7.0, this.pixie.getZ() + (double)this.random.nextInt(15) - 7.0, this.random);
        return !this.pixie.isOwnerClose() && !this.pixie.isPixieSitting() && this.isDirectPathBetweenPoints(this.pixie.blockPosition(), this.target) && !this.pixie.getMoveControl().hasWanted() && this.random.nextInt(4) == 0 && this.pixie.getHousePos() == null;
    }

    protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
        return this.pixie.level().clip(new ClipContext(new Vec3((double)posVec31.getX() + 0.5, (double)posVec31.getY() + 0.5, (double)posVec31.getZ() + 0.5), new Vec3((double)posVec32.getX() + 0.5, (double)posVec32.getY() + (double)this.pixie.getBbHeight() * 0.5, (double)posVec32.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.pixie)).getType() == HitResult.Type.MISS;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void tick() {
        if (!this.isDirectPathBetweenPoints(this.pixie.blockPosition(), this.target)) {
            this.target = PixieEntity.getPositionRelativetoGround((Entity)this.pixie, this.pixie.level(), this.pixie.getX() + (double)this.random.nextInt(15) - 7.0, this.pixie.getZ() + (double)this.random.nextInt(15) - 7.0, this.random);
        }
        if (this.pixie.level().isEmptyBlock(this.target)) {
            this.pixie.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 0.25);
            if (this.pixie.getTarget() == null) {
                this.pixie.getLookControl().setLookAt((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 180.0f, 20.0f);
            }
        }
    }
}

