/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.StymphalianBirdEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class StymphalianBirdAIFleeGoal
extends Goal {
    protected final StymphalianBirdEntity stymphalianBird;
    private final Predicate<Entity> canBeSeenSelector;
    private final float avoidDistance;
    protected LivingEntity closestLivingEntity;
    private Vec3 hidePlace;

    public StymphalianBirdAIFleeGoal(StymphalianBirdEntity stymphalianBird, float avoidDistanceIn) {
        this.stymphalianBird = stymphalianBird;
        this.canBeSeenSelector = entity -> entity instanceof Player && entity.isAlive() && this.stymphalianBird.getSensing().hasLineOfSight(entity) && !this.stymphalianBird.isAlliedTo((Entity)entity);
        this.avoidDistance = avoidDistanceIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.stymphalianBird.getVictor() == null) {
            return false;
        }
        List list = this.stymphalianBird.level().getEntitiesOfClass(LivingEntity.class, this.stymphalianBird.getBoundingBox().inflate((double)this.avoidDistance, 3.0, (double)this.avoidDistance), this.canBeSeenSelector);
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (LivingEntity)list.getFirst();
        if (this.closestLivingEntity != null && this.stymphalianBird.getVictor() != null && this.closestLivingEntity.equals((Object)this.stymphalianBird.getVictor())) {
            Vec3 Vector3d = DefaultRandomPos.getPosAway((PathfinderMob)this.stymphalianBird, (int)32, (int)7, (Vec3)new Vec3(this.closestLivingEntity.getX(), this.closestLivingEntity.getY(), this.closestLivingEntity.getZ()));
            if (Vector3d == null) {
                return false;
            }
            Vector3d = Vector3d.add(0.0, 3.0, 0.0);
            this.stymphalianBird.getMoveControl().setWantedPosition(Vector3d.x, Vector3d.y, Vector3d.z, 3.0);
            this.stymphalianBird.getLookControl().setLookAt(Vector3d.x, Vector3d.y, Vector3d.z, 180.0f, 20.0f);
            this.hidePlace = Vector3d;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.hidePlace != null && this.stymphalianBird.distanceToSqr(this.hidePlace.add(0.5, 0.5, 0.5)) < 2.0;
    }

    public void start() {
        this.stymphalianBird.getMoveControl().setWantedPosition(this.hidePlace.x, this.hidePlace.y, this.hidePlace.z, 3.0);
        this.stymphalianBird.getLookControl().setLookAt(this.hidePlace.x, this.hidePlace.y, this.hidePlace.z, 180.0f, 20.0f);
    }

    public void stop() {
        this.closestLivingEntity = null;
    }
}

