/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.TrollEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrollAIFleeSunGoal
extends Goal {
    private final TrollEntity troll;
    private final double movementSpeed;
    private final Level world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public TrollAIFleeSunGoal(TrollEntity theCreatureIn, double movementSpeedIn) {
        this.troll = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.world.isDay()) {
            return false;
        }
        if (!this.world.canSeeSky(BlockPos.containing((double)this.troll.getBlockX(), (double)this.troll.getBoundingBox().minY, (double)this.troll.getBlockZ()))) {
            return false;
        }
        Vec3 Vector3d = this.findPossibleShelter();
        if (Vector3d == null) {
            return false;
        }
        this.shelterX = Vector3d.x;
        this.shelterY = Vector3d.y;
        this.shelterZ = Vector3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.troll.getNavigation().isDone();
    }

    public void start() {
        this.troll.getNavigation().moveTo(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    private Vec3 findPossibleShelter() {
        RandomSource random = this.troll.getRandom();
        BlockPos blockpos = BlockPos.containing((double)this.troll.getBlockX(), (double)this.troll.getBoundingBox().minY, (double)this.troll.getBlockZ());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (this.world.canSeeSky(blockpos1) || !(this.troll.getWalkTargetValue(blockpos1) < 0.0f)) continue;
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

