/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute;
import com.iafenvoy.iceandfire.registry.IafSounds;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DragonFluteItem
extends Item {
    public DragonFluteItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand hand) {
        ItemStack itemStackIn = player.getItemInHand(hand);
        player.getCooldowns().addCooldown((Item)this, 60);
        float chunksize = 16 * (Integer)IafCommonConfig.INSTANCE.dragon.fluteDistance.getValue();
        List list = worldIn.getEntities((Entity)player, new AABB(player.getX(), player.getY(), player.getZ(), player.getX() + 1.0, player.getY() + 1.0, player.getZ() + 1.0).inflate((double)chunksize, 256.0, (double)chunksize));
        list.sort(new Sorter((Entity)player));
        ArrayList<IDragonFlute> dragons = new ArrayList<IDragonFlute>();
        for (Entity entity : list) {
            if (!(entity instanceof IDragonFlute)) continue;
            IDragonFlute flute = (IDragonFlute)entity;
            dragons.add(flute);
        }
        for (IDragonFlute dragon : dragons) {
            dragon.onHearFlute(player);
        }
        worldIn.playSound(player, player.blockPosition(), (SoundEvent)IafSounds.DRAGONFLUTE.get(), SoundSource.NEUTRAL, 1.0f, 1.75f);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d0 = this.entity.distanceToSqr(entity1);
            double d1 = this.entity.distanceToSqr(entity2);
            return Double.compare(d0, d1);
        }
    }
}

