/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.entity.CockatriceEggEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class RottenEggItem
extends Item
implements ProjectileItem {
    public RottenEggItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!playerIn.isCreative()) {
            itemstack.shrink(1);
        }
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (worldIn.random.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            CockatriceEggEntity egg = new CockatriceEggEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)IafEntities.COCKATRICE_EGG.get()), worldIn, (LivingEntity)playerIn);
            egg.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            worldIn.addFreshEntity((Entity)egg);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        return new CockatriceEggEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)IafEntities.COCKATRICE_EGG.get()), pos.x(), pos.y(), pos.z(), world);
    }
}

