/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.ability;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.item.ability.PostHitAbility;
import com.iafenvoy.iceandfire.network.payload.LightningBoltS2CPayload;
import dev.architectury.networking.NetworkManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightningMultihitAbility
implements PostHitAbility {
    @Override
    public void active(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level;
        if (this.isEnable() && ((Boolean)IafCommonConfig.INSTANCE.tools.dragonLightningAbility.getValue()).booleanValue() && (level = attacker.level()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                Vec3 pos = attacker.position();
                double searchRange = (Double)IafCommonConfig.INSTANCE.tools.dragonLightningSearchRange.getValue();
                LinkedList<Tuple<Vec3, Vec3>> lightnings = new LinkedList<Tuple<Vec3, Vec3>>();
                LinkedList<Tuple> bfsQueue = new LinkedList<Tuple>();
                bfsQueue.add(new Tuple((Object)mob, (Object)EnchantmentHelper.modifyDamage((ServerLevel)world, (ItemStack)stack, (Entity)target, (DamageSource)world.damageSources.mobAttack(attacker), (float)1.0f)));
                LinkedList<Mob> attacked = new LinkedList<Mob>();
                block0: while (!bfsQueue.isEmpty()) {
                    Tuple pair = (Tuple)bfsQueue.poll();
                    Mob mobEntity = (Mob)pair.getA();
                    double damage = (Double)pair.getB();
                    if (mobEntity != target) {
                        mobEntity.hurt(world.damageSources().mobAttack(attacker), (float)damage);
                    }
                    attacked.add(mobEntity);
                    List<Mob> targets = world.getEntitiesOfClass(Mob.class, new AABB(pos.x() - searchRange, pos.y() - searchRange, pos.z() - searchRange, pos.x() + searchRange, pos.y() + searchRange, pos.z() + searchRange)).stream().filter(arg_0 -> ((LivingEntity)attacker).hasLineOfSight(arg_0)).filter(x -> !attacked.contains(x)).toList();
                    for (Mob m : targets) {
                        if (attacked.size() + bfsQueue.size() >= (Integer)IafCommonConfig.INSTANCE.tools.dragonLightningMaxSearchCount.getValue()) continue block0;
                        bfsQueue.add(new Tuple((Object)m, (Object)(damage * (Double)IafCommonConfig.INSTANCE.tools.dragonLightningDamageReduction.getValue())));
                        lightnings.add((Tuple<Vec3, Vec3>)new Tuple((Object)mobEntity.position(), (Object)m.position()));
                    }
                }
                for (ServerPlayer player : world.getPlayers(player1 -> player1.distanceTo((Entity)attacker) < 64.0f)) {
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LightningBoltS2CPayload(lightnings));
                }
            }
        }
    }
}

