/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.data.DragonColor;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class DragonScaleArmorItem
extends ArmorItem {
    private final DragonColor color;

    public DragonScaleArmorItem(DragonColor color, ArmorItem.Type slot) {
        RegistrySupplier<ArmorMaterial> registrySupplier = color.getMaterial();
        Item.Properties properties = new Item.Properties();
        super(registrySupplier, slot, properties.durability(switch (slot) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 397;
            case ArmorItem.Type.CHESTPLATE -> 577;
            case ArmorItem.Type.LEGGINGS -> 541;
            case ArmorItem.Type.BOOTS -> 469;
            case ArmorItem.Type.BODY -> 0;
        }));
        this.color = color;
    }

    public String getDescriptionId() {
        return "item.%s.dragon_%s".formatted("iceandfire", this.type.getName());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)("dragon." + this.color.getName().toLowerCase(Locale.ROOT))).withStyle(this.color.getColorFormatting()));
        tooltip.add((Component)Component.translatable((String)"item.dragonscales_armor.desc").withStyle(ChatFormatting.GRAY));
    }

    public DragonColor getColor() {
        return this.color;
    }
}

