/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.uranus.object.RegistryHelper;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DragonBowItem
extends BowItem {
    private static final Predicate<ItemStack> DRAGON_ARROWS = stack -> stack.is(IafItemTags.DRAGON_ARROWS);

    public DragonBowItem() {
        super(new Item.Properties().durability(584));
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return DRAGON_ARROWS.or(ARROW_ONLY);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            boolean bl = playerEntity.getAbilities().instabuild || EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)world.registryAccess(), (ResourceKey)Enchantments.INFINITY), (ItemStack)stack) > 0;
            ItemStack itemStack = playerEntity.getProjectile(stack);
            if (!itemStack.isEmpty() || bl) {
                int i;
                float f;
                if (itemStack.isEmpty()) {
                    itemStack = new ItemStack((ItemLike)Items.ARROW);
                }
                if (!((double)(f = DragonBowItem.getPowerForTime((int)(i = this.getUseDuration(stack, user) - remainingUseTicks))) < 0.1)) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl && this.getAllSupportedProjectiles().test(itemStack);
                    if (!world.isClientSide) {
                        int j;
                        ArrowItem arrowItem = (ArrowItem)(itemStack.getItem() instanceof ArrowItem ? itemStack.getItem() : Items.ARROW);
                        AbstractArrow persistentProjectileEntity = arrowItem.createArrow(world, itemStack, (LivingEntity)playerEntity, stack);
                        persistentProjectileEntity.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            persistentProjectileEntity.setCritArrow(true);
                        }
                        if ((j = EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)world.registryAccess(), (ResourceKey)Enchantments.POWER), (ItemStack)stack)) > 0) {
                            persistentProjectileEntity.setBaseDamage(persistentProjectileEntity.getBaseDamage() + (double)j * 0.5 + 0.5);
                        }
                        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)world.registryAccess(), (ResourceKey)Enchantments.FLAME), (ItemStack)stack) > 0) {
                            persistentProjectileEntity.igniteForSeconds(100.0f);
                        }
                        stack.hurtAndBreak(1, (LivingEntity)playerEntity, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                        if (bl2 || playerEntity.getAbilities().instabuild && (itemStack.is(Items.SPECTRAL_ARROW) || itemStack.is(Items.TIPPED_ARROW))) {
                            persistentProjectileEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        world.addFreshEntity((Entity)persistentProjectileEntity);
                    }
                    world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!bl2 && !playerEntity.getAbilities().instabuild) {
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            playerEntity.getInventory().removeItem(itemStack);
                        }
                    }
                    playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }
}

