/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.recipe;

import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBlockEntity;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafRecipeSerializers;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DragonForgeRecipe
implements Recipe<DragonForgeBlockEntity.DragonForgeRecipeInput> {
    private final Ingredient input;
    private final Ingredient blood;
    private final ItemStack result;
    private final String dragonType;
    private final int cookTime;

    public DragonForgeRecipe(Ingredient input, Ingredient blood, ItemStack result, String dragonType, int cookTime) {
        this.input = input;
        this.blood = blood;
        this.result = result;
        this.dragonType = dragonType;
        this.cookTime = cookTime;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getBlood() {
        return this.blood;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public String getDragonType() {
        return this.dragonType;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(DragonForgeBlockEntity.DragonForgeRecipeInput inv, Level worldIn) {
        return this.input.test(inv.getStack(0)) && this.blood.test(inv.getStack(1)) && this.dragonType.equals(inv.getTypeID());
    }

    public ItemStack craft(DragonForgeBlockEntity.DragonForgeRecipeInput input, HolderLookup.Provider lookup) {
        return this.result;
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isValidBlood(ItemStack blood) {
        return this.blood.test(blood);
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.result;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)IafBlocks.DRAGONFORGE_FIRE_CORE.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)IafRecipeSerializers.DRAGONFORGE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DragonForgeRecipe> {
        public MapCodec<DragonForgeRecipe> codec() {
            return RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("input").forGetter(DragonForgeRecipe::getInput), (App)Ingredient.CODEC.fieldOf("blood").forGetter(DragonForgeRecipe::getBlood), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(DragonForgeRecipe::getResultItem), (App)Codec.STRING.fieldOf("dragonType").forGetter(DragonForgeRecipe::getDragonType), (App)Codec.INT.fieldOf("cookTime").forGetter(DragonForgeRecipe::getCookTime)).apply((Applicative)i, DragonForgeRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, DragonForgeRecipe> streamCodec() {
            return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DragonForgeRecipe::getInput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DragonForgeRecipe::getBlood, (StreamCodec)ItemStack.STREAM_CODEC, DragonForgeRecipe::getResultItem, (StreamCodec)ByteBufCodecs.STRING_UTF8, DragonForgeRecipe::getDragonType, (StreamCodec)ByteBufCodecs.INT, DragonForgeRecipe::getCookTime, DragonForgeRecipe::new);
        }
    }
}

