/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class IafDamageTypes {
    public static final ResourceKey<DamageType> BONUS = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"bonus"));
    public static final ResourceKey<DamageType> GORGON_DMG_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"gorgon"));
    public static final ResourceKey<DamageType> DRAGON_FIRE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_fire"));
    public static final ResourceKey<DamageType> DRAGON_ICE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_ice"));
    public static final ResourceKey<DamageType> DRAGON_LIGHTNING_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dragon_lightning"));

    private static Holder<DamageType> get(Entity entity, ResourceKey<DamageType> key) {
        Registry registry = entity.level().damageSources.damageTypes;
        return (Holder)registry.getHolder(key).orElse(registry.getHolderOrThrow(DamageTypes.FELL_OUT_OF_WORLD));
    }

    public static DamageSource bonusDamage(Entity attacker) {
        return new DamageSource(IafDamageTypes.get(attacker, BONUS), attacker);
    }

    public static CustomEntityDamageSource causeGorgonDamage(Entity entity) {
        return new CustomEntityDamageSource(IafDamageTypes.get(entity, GORGON_DMG_TYPE), entity);
    }

    public static CustomEntityDamageSource causeDragonFireDamage(Entity entity) {
        return new CustomEntityDamageSource(IafDamageTypes.get(entity, DRAGON_FIRE_TYPE), entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonFireDamage(Entity source, Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(IafDamageTypes.get(indirectEntityIn, DRAGON_FIRE_TYPE), source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonIceDamage(Entity entity) {
        return new CustomEntityDamageSource(IafDamageTypes.get(entity, DRAGON_ICE_TYPE), entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonIceDamage(Entity source, Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(IafDamageTypes.get(indirectEntityIn, DRAGON_ICE_TYPE), source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonLightningDamage(Entity entity) {
        return new CustomEntityDamageSource(IafDamageTypes.get(entity, DRAGON_LIGHTNING_TYPE), entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonLightningDamage(Entity source, Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(IafDamageTypes.get(indirectEntityIn, DRAGON_ICE_TYPE), source, indirectEntityIn);
    }

    public static class CustomEntityDamageSource
    extends DamageSource {
        public CustomEntityDamageSource(Holder<DamageType> damageType, Entity entity) {
            super(damageType, entity);
        }

        public Component getLocalizedDeathMessage(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.getKillCredit();
            String s = "death.attack." + this.getMsgId();
            int index = entityLivingBaseIn.getRandom().nextInt(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.translatable((String)s2, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s1, (Object[])new Object[]{entityLivingBaseIn.getDisplayName()});
        }
    }

    public static class CustomIndirectEntityDamageSource
    extends DamageSource {
        public CustomIndirectEntityDamageSource(Holder<DamageType> damageType, Entity source, Entity entity) {
            super(damageType, source, entity);
        }

        public Component getLocalizedDeathMessage(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.getKillCredit();
            String s = "death.attack." + this.getMsgId();
            int index = entityLivingBaseIn.getRandom().nextInt(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.translatable((String)s2, (Object[])new Object[]{entityLivingBaseIn.getDisplayName(), livingentity.getDisplayName()}) : Component.translatable((String)s1, (Object[])new Object[]{entityLivingBaseIn.getDisplayName()});
        }
    }
}

