/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.item.block.JarBlock;
import com.iafenvoy.iceandfire.item.block.entity.JarBlockEntity;
import com.iafenvoy.iceandfire.render.entity.PixieEntityRenderer;
import com.iafenvoy.iceandfire.render.model.PixieModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class JarBlockEntityRenderer<T extends JarBlockEntity>
implements BlockEntityRenderer<T> {
    public static final RenderType TEXTURE_0 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_0, (boolean)false);
    public static final RenderType TEXTURE_1 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_1, (boolean)false);
    public static final RenderType TEXTURE_2 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_2, (boolean)false);
    public static final RenderType TEXTURE_3 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_3, (boolean)false);
    public static final RenderType TEXTURE_4 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_4, (boolean)false);
    public static final RenderType TEXTURE_5 = RenderType.entityCutoutNoCull((ResourceLocation)PixieEntityRenderer.TEXTURE_5, (boolean)false);
    public static final RenderType TEXTURE_0_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_0);
    public static final RenderType TEXTURE_1_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_1);
    public static final RenderType TEXTURE_2_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_2);
    public static final RenderType TEXTURE_3_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_3);
    public static final RenderType TEXTURE_4_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_4);
    public static final RenderType TEXTURE_5_GLO = RenderType.eyes((ResourceLocation)PixieEntityRenderer.TEXTURE_5);
    private static final Supplier<PixieModel> MODEL_PIXIE = PixieModel::new;

    public JarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int meta = 0;
        boolean hasPixie = false;
        if (entity.getLevel() != null) {
            Block block = entity.getBlockState().getBlock();
            if (block instanceof JarBlock) {
                JarBlock jar = (JarBlock)block;
                meta = jar.getPixieType();
                hasPixie = !jar.isEmpty();
            } else {
                meta = ((JarBlockEntity)((Object)entity)).pixieType;
                hasPixie = ((JarBlockEntity)((Object)entity)).hasPixie;
            }
        }
        if (hasPixie) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 1.501f, 0.5f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStackIn.pushPose();
            RenderType type = switch (meta) {
                case 1 -> TEXTURE_1;
                case 2 -> TEXTURE_2;
                case 3 -> TEXTURE_3;
                case 4 -> TEXTURE_4;
                default -> TEXTURE_0;
            };
            RenderType typeGlow = switch (meta) {
                case 1 -> TEXTURE_1_GLO;
                case 2 -> TEXTURE_2_GLO;
                case 3 -> TEXTURE_3_GLO;
                case 4 -> TEXTURE_4_GLO;
                default -> TEXTURE_0_GLO;
            };
            VertexConsumer buffer = bufferIn.getBuffer(type);
            if (entity.getLevel() != null) {
                if (((JarBlockEntity)((Object)entity)).hasProduced) {
                    matrixStackIn.translate(0.0f, 0.9f, 0.0f);
                } else {
                    matrixStackIn.translate(0.0f, 0.6f, 0.0f);
                }
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(this.interpolateRotation(((JarBlockEntity)((Object)entity)).prevRotationYaw, ((JarBlockEntity)((Object)entity)).rotationYaw, partialTicks)));
                matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                PixieModel model = MODEL_PIXIE.get();
                model.animateInJar(((JarBlockEntity)((Object)entity)).hasProduced, (JarBlockEntity)((Object)entity), 0.0f);
                model.renderToBuffer(matrixStackIn, buffer, combinedLightIn, combinedOverlayIn, -1);
                model.renderToBuffer(matrixStackIn, bufferIn.getBuffer(typeGlow), combinedLightIn, combinedOverlayIn, -1);
            }
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }
}

