/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.GorgonEntity;
import com.iafenvoy.iceandfire.render.entity.feature.GorgonEyesFeatureRenderer;
import com.iafenvoy.iceandfire.render.model.GorgonModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class GorgonEntityRenderer
extends MobRenderer<GorgonEntity, GorgonModel> {
    public static final ResourceLocation PASSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_passive.png");
    public static final ResourceLocation AGRESSIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_active.png");
    public static final ResourceLocation DEAD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/gorgon/gorgon_decapitated.png");

    public GorgonEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GorgonModel(), 0.4f);
        this.layers.add(new GorgonEyesFeatureRenderer(this));
    }

    public void scale(GorgonEntity LivingEntityIn, PoseStack stack, float partialTickTime) {
        stack.scale(0.85f, 0.85f, 0.85f);
    }

    public ResourceLocation getTexture(GorgonEntity gorgon) {
        if (gorgon.getAnimation() == GorgonEntity.ANIMATION_SCARE) {
            return AGRESSIVE_TEXTURE;
        }
        if (gorgon.deathTime > 0) {
            return DEAD_TEXTURE;
        }
        return PASSIVE_TEXTURE;
    }
}

