/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import com.iafenvoy.iceandfire.render.model.HippogryphModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class HippogryphEntityRenderer
extends MobRenderer<HippogryphEntity, HippogryphModel> {
    public HippogryphEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HippogryphModel(), 0.8f);
        this.layers.add(new LayerHippogriffSaddle(this));
    }

    protected void scale(HippogryphEntity entity, PoseStack matrix, float partialTickTime) {
        matrix.scale(1.2f, 1.2f, 1.2f);
    }

    public ResourceLocation getTexture(HippogryphEntity entity) {
        return entity.getEnumVariant().getTexture(entity.isBlinking());
    }

    private static class LayerHippogriffSaddle
    extends RenderLayer<HippogryphEntity, HippogryphModel> {
        private final RenderType SADDLE_TEXTURE = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/saddle.png"));
        private final RenderType BRIDLE = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/bridle.png"));
        private final RenderType CHEST = RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/chest.png"));
        private final RenderType TEXTURE_IRON = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/armor_iron.png"));
        private final RenderType TEXTURE_GOLD = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/armor_gold.png"));
        private final RenderType TEXTURE_DIAMOND = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/armor_diamond.png"));
        private final RenderType TEXTURE_NETHERITE = RenderType.entityNoOutline((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/hippogryph/armor_netherite.png"));

        public LayerHippogriffSaddle(HippogryphEntityRenderer renderer) {
            super((RenderLayerParent)renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HippogryphEntity hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder;
            if (hippo.getArmorValue() != 0) {
                RenderType type = switch (hippo.getArmorValue()) {
                    case 1 -> this.TEXTURE_IRON;
                    case 2 -> this.TEXTURE_GOLD;
                    case 3 -> this.TEXTURE_DIAMOND;
                    case 4 -> this.TEXTURE_NETHERITE;
                    default -> null;
                };
                VertexConsumer ivertexbuilder2 = bufferIn.getBuffer(type);
                ((HippogryphModel)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
            if (hippo.isSaddled()) {
                ivertexbuilder = bufferIn.getBuffer(this.SADDLE_TEXTURE);
                ((HippogryphModel)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
            if (hippo.isSaddled() && hippo.getControllingPassenger() != null) {
                ivertexbuilder = bufferIn.getBuffer(this.BRIDLE);
                ((HippogryphModel)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
            if (hippo.isChested()) {
                ivertexbuilder = bufferIn.getBuffer(this.CHEST);
                ((HippogryphModel)this.getParentModel()).renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
        }
    }
}

