/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.item.armor;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.armor.DragonScaleArmorItem;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.render.model.armor.FireDragonScaleArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.IceDragonScaleArmorModel;
import com.iafenvoy.iceandfire.render.model.armor.LightningDragonScaleArmorModel;
import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScaleArmorRenderer
implements IArmorRendererBase<LivingEntity> {
    private static final Map<DragonType, Boolean2ObjectFunction<HumanoidModel<LivingEntity>>> MODEL_BY_TYPE = new LinkedHashMap<DragonType, Boolean2ObjectFunction<HumanoidModel<LivingEntity>>>();

    public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<LivingEntity> bipedEntityModel) {
        HumanoidModel humanoidModel;
        Item item = itemStack.getItem();
        if (item instanceof DragonScaleArmorItem) {
            DragonScaleArmorItem scaleArmor = (DragonScaleArmorItem)item;
            humanoidModel = (HumanoidModel)MODEL_BY_TYPE.getOrDefault(scaleArmor.getColor().getType(), (Boolean2ObjectFunction<HumanoidModel<LivingEntity>>)((Boolean2ObjectFunction)b -> null)).get(armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.HEAD);
        } else {
            humanoidModel = null;
        }
        return humanoidModel;
    }

    public static void register(DragonType type, Boolean2ObjectFunction<HumanoidModel<LivingEntity>> model) {
        MODEL_BY_TYPE.put(type, model);
    }

    static {
        ScaleArmorRenderer.register(IafDragonTypes.FIRE, (Boolean2ObjectFunction<HumanoidModel<LivingEntity>>)((Boolean2ObjectFunction)FireDragonScaleArmorModel::new));
        ScaleArmorRenderer.register(IafDragonTypes.ICE, (Boolean2ObjectFunction<HumanoidModel<LivingEntity>>)((Boolean2ObjectFunction)IceDragonScaleArmorModel::new));
        ScaleArmorRenderer.register(IafDragonTypes.LIGHTNING, (Boolean2ObjectFunction<HumanoidModel<LivingEntity>>)((Boolean2ObjectFunction)LightningDragonScaleArmorModel::new));
    }
}

