/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.entity.GhostEntity;
import com.iafenvoy.iceandfire.render.model.BipedBaseModel;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ModelAnimator;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.HideableModelRenderer;

public class GhostModel
extends BipedBaseModel<GhostEntity> {
    public final AdvancedModelBox robe;
    public final AdvancedModelBox mask;
    public final AdvancedModelBox hood;
    public final AdvancedModelBox jaw;
    public final AdvancedModelBox sleeveRight;
    public final AdvancedModelBox robeLowerRight;
    public final AdvancedModelBox robeLowerLeft;
    public final AdvancedModelBox sleeveLeft;

    public GhostModel(float modelScale) {
        this.texWidth = 128;
        this.texHeight = 64;
        this.sleeveRight = new AdvancedModelBox((AdvancedEntityModel)this, 33, 35);
        this.sleeveRight.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveRight.addBox(-2.2f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f, 0.0f, modelScale);
        this.body = new HideableModelRenderer((AdvancedEntityModel)this, 16, 16);
        this.body.setPos(0.0f, 0.0f, 0.0f);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f, 0.0f, modelScale);
        this.robeLowerRight = new AdvancedModelBox((AdvancedEntityModel)this, 48, 35);
        this.robeLowerRight.mirror = true;
        this.robeLowerRight.setPos(0.0f, 0.0f, 0.0f);
        this.robeLowerRight.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, 0.0f, modelScale);
        this.armLeft = new HideableModelRenderer((AdvancedEntityModel)this, 40, 16);
        this.armLeft.mirror = true;
        this.armLeft.setPos(5.0f, 2.0f, -0.0f);
        this.armLeft.addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 0.0f, modelScale);
        this.setRotateAngle((AdvancedModelBox)this.armLeft, -1.457001f, 0.10000737f, -0.10000737f);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this, 98, 8);
        this.jaw.setPos(0.0f, -1.4f, 0.2f);
        this.jaw.addBox(-2.0f, 0.0f, -4.5f, 4.0f, 2.0f, 8.0f, 0.0f, 0.0f, modelScale);
        this.setRotateAngle(this.jaw, 0.13665928f, 0.0f, 0.0f);
        this.hood = new AdvancedModelBox((AdvancedEntityModel)this, 60, 0);
        this.hood.setPos(0.0f, 0.0f, 0.0f);
        this.hood.addBox(-4.5f, -8.6f, -4.5f, 9.0f, 9.0f, 9.0f, 0.0f, 0.0f, modelScale);
        this.legLeft = new HideableModelRenderer((AdvancedEntityModel)this, 0, 16);
        this.legLeft.mirror = true;
        this.legLeft.setPos(2.2f, 12.0f, 0.1f);
        this.legLeft.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 0.0f, modelScale);
        this.head = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, modelScale);
        this.mask = new AdvancedModelBox((AdvancedEntityModel)this, 40, 8);
        this.mask.setPos(0.0f, 0.0f, 0.0f);
        this.mask.addBox(-4.0f, -8.6f, -4.4f, 8.0f, 8.0f, 0.0f, 0.0f, 0.0f, modelScale);
        this.armRight = new HideableModelRenderer((AdvancedEntityModel)this, 40, 16);
        this.armRight.setPos(-5.0f, 2.0f, 0.0f);
        this.armRight.addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 0.0f, modelScale);
        this.setRotateAngle((AdvancedModelBox)this.armRight, -1.457001f, -0.10000737f, 0.10000737f);
        this.robe = new AdvancedModelBox((AdvancedEntityModel)this, 4, 34);
        this.robe.setPos(0.0f, 0.1f, 0.0f);
        this.robe.addBox(-4.5f, 0.0f, -2.5f, 9.0f, 12.0f, 5.0f, 0.0f, 0.0f, modelScale);
        this.legRight = new HideableModelRenderer((AdvancedEntityModel)this, 0, 16);
        this.legRight.setPos(-2.3f, 12.0f, 0.1f);
        this.legRight.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 0.0f, 0.0f, modelScale);
        this.robeLowerLeft = new AdvancedModelBox((AdvancedEntityModel)this, 48, 35);
        this.robeLowerLeft.setPos(0.0f, 0.0f, 0.0f);
        this.robeLowerLeft.addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, 0.0f, modelScale);
        this.sleeveLeft = new AdvancedModelBox((AdvancedEntityModel)this, 33, 35);
        this.sleeveLeft.mirror = true;
        this.sleeveLeft.setPos(0.0f, -0.1f, 0.0f);
        this.sleeveLeft.addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f, 0.0f, modelScale);
        this.armRight.addChild((BasicModelPart)this.sleeveRight);
        this.legRight.addChild((BasicModelPart)this.robeLowerRight);
        this.body.addChild((BasicModelPart)this.armLeft);
        this.mask.addChild((BasicModelPart)this.jaw);
        this.head.addChild((BasicModelPart)this.hood);
        this.body.addChild((BasicModelPart)this.legLeft);
        this.body.addChild((BasicModelPart)this.head);
        this.head.addChild((BasicModelPart)this.mask);
        this.body.addChild((BasicModelPart)this.armRight);
        this.body.addChild((BasicModelPart)this.robe);
        this.body.addChild((BasicModelPart)this.legRight);
        this.legLeft.addChild((BasicModelPart)this.robeLowerLeft);
        this.armLeft.addChild((BasicModelPart)this.sleeveLeft);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    @Override
    public void setAngles(GhostEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch, 1.0f);
        this.faceTarget(headYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        float speed_walk = 0.6f;
        float speed_idle = 0.05f;
        float degree_walk = 1.0f;
        float degree_idle = 0.25f;
        float f12 = (float)Math.toRadians(-1.29f) + limbDistance;
        if (f12 < 0.0f) {
            f12 = 0.0f;
        }
        if ((double)f12 > Math.toRadians(20.0)) {
            f12 = (float)Math.toRadians(20.0);
        }
        this.body.rotateAngleX = f12;
        this.head.rotateAngleX -= f12;
        this.armRight.rotateAngleX -= f12;
        this.armLeft.rotateAngleX -= f12;
        this.walk(this.jaw, speed_idle * 2.0f, degree_idle * 0.5f, false, 0.0f, 0.1f, animationProgress, 1.0f);
        this.walk((AdvancedModelBox)this.armRight, speed_idle * 1.5f, degree_idle * 0.4f, false, 2.0f, 0.0f, animationProgress, 1.0f);
        this.walk((AdvancedModelBox)this.armLeft, speed_idle * 1.5f, degree_idle * 0.4f, true, 2.0f, 0.0f, animationProgress, 1.0f);
        this.flap((AdvancedModelBox)this.armRight, speed_idle * 1.5f, degree_idle * 0.2f, false, 2.0f, 0.2f, animationProgress, 1.0f);
        this.flap((AdvancedModelBox)this.armRight, speed_idle * 1.5f, degree_idle * 0.2f, true, 2.0f, 0.2f, animationProgress, 1.0f);
        this.walk((AdvancedModelBox)this.legLeft, speed_idle * 1.5f, degree_idle * 0.4f, false, 2.0f, 0.2f, animationProgress, 1.0f);
        this.walk((AdvancedModelBox)this.legRight, speed_idle * 1.5f, degree_idle * 0.4f, false, 2.0f, 0.2f, animationProgress, 1.0f);
        this.flap((AdvancedModelBox)this.body, speed_idle, degree_idle * 0.1f, true, 3.0f, 0.0f, animationProgress, 1.0f);
        this.bob((AdvancedModelBox)this.body, speed_idle * 0.5f, degree_idle * 4.1f, false, animationProgress, 1.0f);
        this.bob((AdvancedModelBox)this.body, speed_walk * 0.75f, degree_walk * 2.1f, false, limbAngle, limbDistance);
    }

    @Override
    public void animate(GhostEntity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.animator.startAnimate((IAnimatedEntity)entity);
        if (this.animator.setAnimation(GhostEntity.ANIMATION_SCARE)) {
            this.animator.startKeyframe(5);
            this.animator.move((AdvancedModelBox)this.head, 0.0f, -2.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armLeft, 0.0f, 1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armRight, 0.0f, 1.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.head, 0.0f, 20.0f, 0.0f);
            this.rotateMinus(this.animator, this.jaw, 20.0f, 10.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armLeft, 30.0f, -12.5f, -70.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armRight, -30.0f, 12.5f, 70.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(5);
            this.animator.move((AdvancedModelBox)this.head, 0.0f, -1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armLeft, 0.0f, -1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armRight, 0.0f, -1.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.head, 0.0f, -20.0f, 0.0f);
            this.rotateMinus(this.animator, this.jaw, 20.0f, -10.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armLeft, -20.0f, -25.0f, -140.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armRight, 20.0f, 25.0f, 140.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(5);
            this.animator.move((AdvancedModelBox)this.head, 0.0f, -2.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armLeft, 0.0f, 1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armRight, 0.0f, 1.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.head, 0.0f, 20.0f, 0.0f);
            this.rotateMinus(this.animator, this.jaw, 20.0f, 10.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armLeft, 30.0f, -25.0f, -140.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armRight, -30.0f, 25.0f, 140.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(5);
            this.animator.move((AdvancedModelBox)this.head, 0.0f, -1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armLeft, 0.0f, -1.0f, 0.0f);
            this.animator.move((AdvancedModelBox)this.armRight, 0.0f, -1.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.head, 0.0f, -20.0f, 0.0f);
            this.rotateMinus(this.animator, this.jaw, 20.0f, -10.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armLeft, -20.0f, -25.0f, -140.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armRight, 20.0f, 25.0f, 140.0f);
            this.animator.endKeyframe();
            this.animator.resetKeyframe(10);
        }
        if (this.animator.setAnimation(GhostEntity.ANIMATION_HIT)) {
            this.animator.startKeyframe(5);
            this.animator.move((AdvancedModelBox)this.head, 0.0f, -1.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.body, 0.0f, 0.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.head, -20.0f, 0.0f, 0.0f);
            this.rotateMinus(this.animator, this.jaw, 70.0f, 0.0f, 0.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armRight, -180.0f, 0.0f, -30.0f);
            this.rotateMinus(this.animator, (AdvancedModelBox)this.armLeft, -180.0f, 0.0f, 30.0f);
            this.animator.endKeyframe();
            this.animator.resetKeyframe(5);
        }
        this.animator.endAnimate();
    }

    @Override
    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.head, (Object)this.headware, (Object)this.body, (Object)this.armRight, (Object)this.armLeft, (Object)this.legRight, (Object)this.legLeft, (Object)this.robe, (Object)this.mask, (Object)this.hood, (Object)this.jaw, (Object)this.sleeveRight, (Object[])new AdvancedModelBox[]{this.robeLowerRight, this.robeLowerLeft, this.sleeveLeft});
    }
}

