/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.entity.PixieEntity;
import com.iafenvoy.iceandfire.item.block.entity.JarBlockEntity;
import com.iafenvoy.iceandfire.item.block.entity.PixieHouseBlockEntity;
import com.iafenvoy.iceandfire.render.model.DragonBaseModel;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class PixieModel
extends DragonBaseModel<PixieEntity> {
    public final AdvancedModelBox Body;
    public final AdvancedModelBox Left_Arm;
    public final AdvancedModelBox Head;
    public final AdvancedModelBox Right_Arm;
    public final AdvancedModelBox Neck;
    public final AdvancedModelBox Left_Leg;
    public final AdvancedModelBox Right_Leg;
    public final AdvancedModelBox Left_Wing;
    public final AdvancedModelBox Left_Wing2;
    public final AdvancedModelBox Right_Wing;
    public final AdvancedModelBox Right_Wing2;
    public final AdvancedModelBox Dress;

    public PixieModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.Neck = new AdvancedModelBox((AdvancedEntityModel)this, 40, 25);
        this.Neck.setPos(0.0f, -8.2f, 0.0f);
        this.Neck.addBox(-1.5f, -1.1f, -1.0f, 3.0f, 1.0f, 1.0f, 0.0f);
        this.Right_Arm = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.Right_Arm.setPos(-1.8f, -7.0f, 0.0f);
        this.Right_Arm.addBox(-0.6f, -0.5f, -1.0f, 1.0f, 6.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Right_Arm, 0.0f, 0.0f, 0.17453292f);
        this.Right_Wing2 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 10);
        this.Right_Wing2.setPos(-1.4f, -5.0f, -0.1f);
        this.Right_Wing2.addBox(-1.2f, -0.5f, 0.5f, 3.0f, 10.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Right_Wing2, 0.5235988f, -0.018325957f, 1.0471976f);
        this.Right_Wing = new AdvancedModelBox((AdvancedEntityModel)this, 14, 10);
        this.Right_Wing.setPos(-1.2f, -6.3f, 0.4f);
        this.Right_Wing.addBox(-1.2f, -0.5f, 0.5f, 3.0f, 12.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Right_Wing, 0.5235988f, -0.2617994f, 1.7453293f);
        this.Body = new AdvancedModelBox((AdvancedEntityModel)this, 0, 8);
        this.Body.setPos(0.0f, 16.9f, 0.5f);
        this.Body.addBox(-1.5f, -7.9f, -1.4f, 3.0f, 5.0f, 2.0f, 0.0f);
        this.Right_Leg = new AdvancedModelBox((AdvancedEntityModel)this, 5, 17);
        this.Right_Leg.mirror = true;
        this.Right_Leg.setPos(-0.8f, -1.5f, 0.0f);
        this.Right_Leg.addBox(-0.6f, -0.5f, -0.9f, 1.0f, 6.0f, 1.0f, 0.0f);
        this.Dress = new AdvancedModelBox((AdvancedEntityModel)this, 0, 24);
        this.Dress.setPos(0.0f, -2.5f, 0.1f);
        this.Dress.addBox(-2.0f, -0.4f, -1.5f, 4.0f, 3.0f, 2.0f, 0.0f);
        this.Head = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.Head.setPos(0.0f, -8.0f, -0.8f);
        this.Head.addBox(-2.0f, -3.8f, -1.6f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.Left_Wing = new AdvancedModelBox((AdvancedEntityModel)this, 14, 10);
        this.Left_Wing.mirror = true;
        this.Left_Wing.setPos(1.2f, -6.3f, 0.4f);
        this.Left_Wing.addBox(-1.8f, -0.5f, 0.5f, 3.0f, 12.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Left_Wing, 0.5235988f, 0.2617994f, -1.7453293f);
        this.Left_Leg = new AdvancedModelBox((AdvancedEntityModel)this, 5, 17);
        this.Left_Leg.setPos(0.8f, -1.5f, 0.0f);
        this.Left_Leg.addBox(-0.6f, -0.5f, -0.9f, 1.0f, 6.0f, 1.0f, 0.0f);
        this.Left_Wing2 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 10);
        this.Left_Wing2.mirror = true;
        this.Left_Wing2.setPos(1.4f, -5.0f, -0.1f);
        this.Left_Wing2.addBox(-1.8f, -0.5f, 0.5f, 3.0f, 10.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Left_Wing2, 0.5235988f, 0.018325957f, -1.0471976f);
        this.Left_Arm = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.Left_Arm.setPos(1.8f, -7.0f, 0.0f);
        this.Left_Arm.addBox(-0.6f, -0.5f, -0.9f, 1.0f, 6.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.Left_Arm, 0.0f, 0.0f, -0.17453292f);
        this.Body.addChild((BasicModelPart)this.Neck);
        this.Body.addChild((BasicModelPart)this.Right_Arm);
        this.Body.addChild((BasicModelPart)this.Right_Wing2);
        this.Body.addChild((BasicModelPart)this.Right_Wing);
        this.Body.addChild((BasicModelPart)this.Right_Leg);
        this.Body.addChild((BasicModelPart)this.Dress);
        this.Body.addChild((BasicModelPart)this.Head);
        this.Body.addChild((BasicModelPart)this.Left_Wing);
        this.Body.addChild((BasicModelPart)this.Left_Leg);
        this.Body.addChild((BasicModelPart)this.Left_Wing2);
        this.Body.addChild((BasicModelPart)this.Left_Arm);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.Body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.Body, (Object)this.Left_Arm, (Object)this.Head, (Object)this.Right_Arm, (Object)this.Neck, (Object)this.Left_Leg, (Object)this.Right_Leg, (Object)this.Left_Wing, (Object)this.Left_Wing2, (Object)this.Right_Wing, (Object)this.Right_Wing2, (Object)this.Dress, (Object[])new AdvancedModelBox[0]);
    }

    public void setAngles(PixieEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.resetToDefaultPose();
        float speed_fly = 1.1f;
        float speed_idle = 0.05f;
        float degree_fly = 1.0f;
        float degree_idle = 0.5f;
        AdvancedModelBox[] LEFT_WINGS = new AdvancedModelBox[]{this.Left_Wing, this.Left_Wing2};
        AdvancedModelBox[] RIGHT_WINGS = new AdvancedModelBox[]{this.Right_Wing, this.Right_Wing2};
        this.Left_Leg.rotateAngleX = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.0f * limbDistance * 0.5f;
        this.Right_Leg.rotateAngleX = Mth.cos((float)(limbAngle * 0.6662f)) * 1.0f * limbDistance * 0.5f;
        float f12 = limbDistance;
        if (f12 < 0.0f) {
            f12 = 0.0f;
        }
        if ((double)f12 > Math.toRadians(20.0)) {
            f12 = (float)Math.toRadians(20.0);
        }
        this.Body.rotateAngleX = f12;
        this.Head.rotateAngleX -= f12;
        ItemStack itemstack = entity.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemstack.isEmpty()) {
            this.faceTarget(headYaw, headPitch, 1.0f, this.Head);
            this.Left_Arm.rotateAngleX += (float)Math.toRadians(-35.0);
            this.Right_Arm.rotateAngleX += (float)Math.toRadians(-35.0);
            this.Body.rotateAngleX += (float)Math.toRadians(10.0);
            this.Left_Leg.rotateAngleX += (float)Math.toRadians(-10.0);
            this.Right_Leg.rotateAngleX += (float)Math.toRadians(-10.0);
            this.Head.rotateAngleX += (float)Math.toRadians(-10.0);
        } else {
            this.Right_Arm.rotateAngleX = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.0f * limbDistance * 0.5f;
            this.Left_Arm.rotateAngleX = Mth.cos((float)(limbAngle * 0.6662f)) * 1.0f * limbDistance * 0.5f;
        }
        if (entity.isPixieSitting()) {
            this.Right_Arm.rotateAngleX -= 0.62831855f;
            this.Left_Arm.rotateAngleX -= 0.62831855f;
            this.Right_Leg.rotateAngleX = -1.4137167f;
            this.Right_Leg.rotateAngleY = 0.31415927f;
            this.Right_Leg.rotateAngleZ = 0.07853982f;
            this.Left_Leg.rotateAngleX = -1.4137167f;
            this.Left_Leg.rotateAngleY = -0.31415927f;
            this.Left_Leg.rotateAngleZ = -0.07853982f;
            this.Dress.rotateAngleX += (float)Math.toRadians(-50.0);
            this.Dress.rotationPointZ += 0.25f;
            this.Dress.rotationPointY += 0.35f;
            this.Left_Wing.rotateAngleZ = (float)Math.toRadians(-28.0);
            this.Right_Wing.rotateAngleZ = (float)Math.toRadians(28.0);
            this.Left_Wing2.rotateAngleZ = (float)Math.toRadians(-8.0);
            this.Right_Wing2.rotateAngleZ = (float)Math.toRadians(8.0);
        } else {
            this.chainWave(LEFT_WINGS, speed_fly, degree_fly * 0.75f, 1.0, animationProgress, 1.0f);
            this.chainWave(RIGHT_WINGS, speed_fly, degree_fly * 0.75f, 1.0, animationProgress, 1.0f);
        }
    }

    public void animateInHouse(PixieHouseBlockEntity house) {
        this.resetToDefaultPose();
        float speed_fly = 1.1f;
        float speed_idle = 0.05f;
        float degree_fly = 1.0f;
        float degree_idle = 0.5f;
        AdvancedModelBox[] LEFT_WINGS = new AdvancedModelBox[]{this.Left_Wing, this.Left_Wing2};
        AdvancedModelBox[] RIGHT_WINGS = new AdvancedModelBox[]{this.Right_Wing, this.Right_Wing2};
        this.Right_Arm.rotateAngleX -= 0.62831855f;
        this.Left_Arm.rotateAngleX -= 0.62831855f;
        this.Right_Leg.rotateAngleX = -1.4137167f;
        this.Right_Leg.rotateAngleY = 0.31415927f;
        this.Right_Leg.rotateAngleZ = 0.07853982f;
        this.Left_Leg.rotateAngleX = -1.4137167f;
        this.Left_Leg.rotateAngleY = -0.31415927f;
        this.Left_Leg.rotateAngleZ = -0.07853982f;
        this.Dress.rotateAngleX += (float)Math.toRadians(-50.0);
        this.Dress.rotationPointZ += 0.25f;
        this.Dress.rotationPointY += 0.35f;
        this.Left_Wing.rotateAngleZ = (float)Math.toRadians(-28.0);
        this.Right_Wing.rotateAngleZ = (float)Math.toRadians(28.0);
        this.Left_Wing2.rotateAngleZ = (float)Math.toRadians(-8.0);
        this.Right_Wing2.rotateAngleZ = (float)Math.toRadians(8.0);
    }

    public void animateInJar(boolean sitting, JarBlockEntity jar, float headRot) {
        this.resetToDefaultPose();
        float speed_fly = 1.1f;
        float speed_idle = 0.05f;
        float degree_fly = 1.0f;
        float degree_idle = 0.5f;
        AdvancedModelBox[] LEFT_WINGS = new AdvancedModelBox[]{this.Left_Wing, this.Left_Wing2};
        AdvancedModelBox[] RIGHT_WINGS = new AdvancedModelBox[]{this.Right_Wing, this.Right_Wing2};
        if (sitting) {
            this.Right_Arm.rotateAngleX -= 0.62831855f;
            this.Left_Arm.rotateAngleX -= 0.62831855f;
            this.Right_Leg.rotateAngleX = -1.4137167f;
            this.Right_Leg.rotateAngleY = 0.31415927f;
            this.Right_Leg.rotateAngleZ = 0.07853982f;
            this.Left_Leg.rotateAngleX = -1.4137167f;
            this.Left_Leg.rotateAngleY = -0.31415927f;
            this.Left_Leg.rotateAngleZ = -0.07853982f;
            this.Dress.rotateAngleX += (float)Math.toRadians(-50.0);
            this.Dress.rotationPointZ += 0.25f;
            this.Dress.rotationPointY += 0.35f;
            this.Left_Wing.rotateAngleZ = (float)Math.toRadians(-28.0);
            this.Right_Wing.rotateAngleZ = (float)Math.toRadians(28.0);
            this.Left_Wing2.rotateAngleZ = (float)Math.toRadians(-8.0);
            this.Right_Wing2.rotateAngleZ = (float)Math.toRadians(8.0);
        } else if (jar != null) {
            float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            this.chainWave(LEFT_WINGS, speed_fly, degree_fly * 0.75f, 1.0, (float)jar.ticksExisted + partialTicks, 1.0f);
            this.chainWave(RIGHT_WINGS, speed_fly, degree_fly * 0.75f, 1.0, (float)jar.ticksExisted + partialTicks, 1.0f);
        }
    }

    @Override
    public void renderStatue(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, Entity living) {
        this.renderToBuffer(matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
    }
}

