/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.uranus.util.RandomHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.resources.ResourceLocation;

public class TitleScreenRenderManager {
    public static final ResourceLocation splash = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"splashes.txt");
    public static final ResourceLocation[] pageFlipTextures;
    public static final ResourceLocation[] drawingTextures;
    private static final ResourceLocation BESTIARY_TEXTURE;
    private static final ResourceLocation TABLE_TEXTURE;
    private static final Font textRenderer;
    private static int layerTick;
    private static List<String> splashText;
    private static boolean isFlippingPage;
    private static int pageFlip;
    private static Picture[] drawnPictures;
    private static float globalAlpha;

    public static SplashRenderer getSplash() {
        if (TitleScreenRenderManager.splashText == null) {
            try {
                BufferedReader bufferedReader = Minecraft.getInstance().getResourceManager().openAsReader(splash);
                TitleScreenRenderManager.splashText = bufferedReader.lines().map(String::trim).filter(splashText -> splashText.hashCode() != 125780783).toList();
                bufferedReader.close();
            }
            catch (IOException var8) {
                TitleScreenRenderManager.splashText = new ArrayList<String>();
            }
        }
        if (TitleScreenRenderManager.splashText.isEmpty()) {
            return null;
        }
        return new SplashRenderer(TitleScreenRenderManager.splashText.get(RandomHelper.nextInt((int)0, (int)(TitleScreenRenderManager.splashText.size() - 1))));
    }

    private static void resetDrawnImages() {
        globalAlpha = 0.0f;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        drawnPictures = new Picture[2];
        boolean left = ((Random)random).nextBoolean();
        for (int i = 0; i < drawnPictures.length; ++i) {
            left = !left;
            int x = left ? -15 - ((Random)random).nextInt(20) - 128 : 30 + ((Random)random).nextInt(20);
            int y = ((Random)random).nextInt(25);
            TitleScreenRenderManager.drawnPictures[i] = new Picture(((Random)random).nextInt(drawingTextures.length), x, y, 0.5f, ((Random)random).nextFloat() * 0.5f + 0.5f);
        }
    }

    public static void tick() {
        float flipTick = layerTick % 40;
        if (globalAlpha < 1.0f && !isFlippingPage && flipTick < 30.0f) {
            globalAlpha += 0.1f;
        }
        if (globalAlpha > 0.0f && flipTick > 30.0f) {
            globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !isFlippingPage) {
            isFlippingPage = true;
        }
        if (isFlippingPage) {
            if (layerTick % 2 == 0) {
                ++pageFlip;
            }
            if (pageFlip == 6) {
                pageFlip = 0;
                isFlippingPage = false;
                TitleScreenRenderManager.resetDrawnImages();
            }
        }
        ++layerTick;
    }

    public static void renderBackground(GuiGraphics ms, int width, int height) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        ms.blit(TABLE_TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
        ms.blit(BESTIARY_TEXTURE, 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        if (isFlippingPage) {
            ms.blit(pageFlipTextures[Math.min(5, pageFlip)], 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        } else {
            int middleX = width / 2;
            int middleY = height / 5;
            float widthScale = (float)width / 427.0f;
            float heightScale = (float)height / 427.0f;
            float imageScale = Math.min(widthScale, heightScale) * 192.0f;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
            for (Picture picture : drawnPictures) {
                int x = (int)((float)picture.x * widthScale) + middleX;
                int y = (int)((float)picture.y * heightScale + (float)middleY);
                ms.blit(drawingTextures[picture.image], x, y, 0.0f, 0.0f, (int)imageScale, (int)imageScale, (int)imageScale, (int)imageScale);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    public static void drawModName(GuiGraphics ms, int width, int height, int alphaFormatted) {
        int textColor = 0xFFFFFF | alphaFormatted;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        boolean b = Platform.isFabric();
        ms.drawString(textRenderer, "Ice and Fire CE-" + String.valueOf(ChatFormatting.GOLD) + IceAndFire.VERSION, 2, height - (b ? 20 : 30), textColor, false);
    }

    static {
        drawingTextures = new ResourceLocation[23];
        BESTIARY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/bestiary_menu.png");
        TABLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/table.png");
        textRenderer = Minecraft.getInstance().font;
        isFlippingPage = false;
        pageFlip = 0;
        globalAlpha = 1.0f;
        pageFlipTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_1.png"), ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_2.png"), ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_3.png"), ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_4.png"), ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_5.png"), ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            TitleScreenRenderManager.drawingTextures[i] = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/gui/main_menu/drawing_" + i + ".png"));
        }
        TitleScreenRenderManager.resetDrawnImages();
    }

    private static class Picture {
        final int image;
        final int x;
        final int y;
        final float alpha;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

