/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.feature;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.HippocampusEntity;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class HippocampusSpawnFeature
extends Feature<NoneFeatureConfiguration> {
    public HippocampusSpawnFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, context.origin().offset(8, 0, 8));
        BlockPos oceanPos = world.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR_WG, pos.offset(8, 0, 8));
        if (random.nextDouble() < (Double)IafCommonConfig.INSTANCE.hippocampus.spawnChance.getValue()) {
            for (int i = 0; i < random.nextInt(5); ++i) {
                BlockPos spawnPos = oceanPos.offset(random.nextInt(10) - 5, random.nextInt(30), random.nextInt(10) - 5);
                if (world.getFluidState(spawnPos).getType() != Fluids.WATER) continue;
                HippocampusEntity campus = (HippocampusEntity)((EntityType)IafEntities.HIPPOCAMPUS.get()).create((Level)world.getLevel());
                assert (campus != null);
                campus.setVariant(random.nextInt(6));
                campus.moveTo((float)spawnPos.getX() + 0.5f, (float)spawnPos.getY() + 0.5f, (float)spawnPos.getZ() + 0.5f, 0.0f, 0.0f);
                world.addFreshEntity((Entity)campus);
            }
        }
        return true;
    }
}

