/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.armor.DragonScaleArmorItem;
import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.render.texture.DragonTextureProvider;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public final class DragonColor {
    private final String name;
    private final class_124 color;
    private final DragonType dragonType;
    private final DragonTextureProvider textureProvider;
    private final Supplier<class_1792> eggItem;
    private final Supplier<class_1792> scaleItem;
    public RegistrySupplier<class_1792> helmet;
    public RegistrySupplier<class_1792> chestplate;
    public RegistrySupplier<class_1792> leggings;
    public RegistrySupplier<class_1792> boots;
    private RegistrySupplier<class_1741> material;

    public DragonColor(String name, class_124 color, DragonType dragonType, Supplier<class_1792> eggItem, Supplier<class_1792> scaleItem) {
        this(name, color, dragonType, DragonTextureProvider::new, eggItem, scaleItem);
    }

    public DragonColor(String name, class_124 color, DragonType dragonType, BiFunction<DragonType, String, DragonTextureProvider> textureProvider, Supplier<class_1792> eggItem, Supplier<class_1792> scaleItem) {
        this.name = name;
        this.color = color;
        this.dragonType = dragonType;
        this.dragonType.colors().add(this);
        this.textureProvider = textureProvider.apply(this.dragonType, this.name);
        this.eggItem = eggItem;
        this.scaleItem = scaleItem;
    }

    public static void initArmors() {
        for (DragonColor color : IafRegistries.DRAGON_COLOR.method_10220().toList()) {
            color.material = IafArmorMaterials.register("dragon_scales_" + color.name, new int[]{5, 7, 9, 5}, 15, (class_6880<class_3414>)class_3417.field_15191, 2.0f, (Supplier<class_1856>)new MemorizeSupplier(() -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)color.scaleItem.get()})));
            String sub = "armor_" + color.getName().toLowerCase(Locale.ROOT);
            color.helmet = IafItems.registerArmor(sub + "_helmet", () -> new DragonScaleArmorItem(color, class_1738.class_8051.field_41934));
            color.chestplate = IafItems.registerArmor(sub + "_chestplate", () -> new DragonScaleArmorItem(color, class_1738.class_8051.field_41935));
            color.leggings = IafItems.registerArmor(sub + "_leggings", () -> new DragonScaleArmorItem(color, class_1738.class_8051.field_41936));
            color.boots = IafItems.registerArmor(sub + "_boots", () -> new DragonScaleArmorItem(color, class_1738.class_8051.field_41937));
        }
    }

    public static DragonColor getById(String id) {
        return (DragonColor)IafRegistries.DRAGON_COLOR.method_10223(IceAndFire.id(id));
    }

    public DragonTextureProvider getTextureProvider() {
        return this.textureProvider;
    }

    public class_1792 getEggItem() {
        return this.eggItem.get();
    }

    public class_1792 getScaleItem() {
        return this.scaleItem.get();
    }

    public String getName() {
        return this.name;
    }

    public class_124 getColorFormatting() {
        return this.color;
    }

    public DragonType getType() {
        return this.dragonType;
    }

    public RegistrySupplier<class_1741> getMaterial() {
        return this.material;
    }
}

