/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.iafenvoy.iceandfire.registry.IafHippogryphTypes;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public record HippogryphType(String name, boolean developer, class_6862<class_1959> spawnBiomes) {
    public static HippogryphType[] getWildTypes() {
        return new HippogryphType[]{IafHippogryphTypes.BLACK, IafHippogryphTypes.BROWN, IafHippogryphTypes.GRAY, IafHippogryphTypes.CHESTNUT, IafHippogryphTypes.CREAMY, IafHippogryphTypes.DARK_BROWN, IafHippogryphTypes.WHITE};
    }

    public static HippogryphType getRandomType() {
        return HippogryphType.getWildTypes()[ThreadLocalRandom.current().nextInt(HippogryphType.getWildTypes().length - 1)];
    }

    public static HippogryphType getBiomeType(class_6880<class_1959> biome) {
        List<HippogryphType> types = IafRegistries.HIPPOGRYPH_TYPE.method_10220().filter(x -> x.allowSpawn(biome)).toList();
        if (types.isEmpty()) {
            return HippogryphType.getRandomType();
        }
        if (types.contains(IafHippogryphTypes.GRAY) && types.contains(IafHippogryphTypes.CHESTNUT)) {
            return IafHippogryphTypes.GRAY;
        }
        return types.get(ThreadLocalRandom.current().nextInt(types.size()));
    }

    public boolean allowSpawn(class_6880<class_1959> biome) {
        return biome.method_40220(this.spawnBiomes);
    }

    public class_2960 getTexture(boolean blink) {
        return class_2960.method_60655((String)"iceandfire", (String)("textures/entity/hippogryph/" + this.name.toLowerCase(Locale.ROOT) + (blink ? "_blink" : "") + ".png"));
    }
}

