/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.util.attachment.NeedUpdateData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ChainData
extends NeedUpdateData<class_1309> {
    public static final Codec<ChainData> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_4844.field_40825.listOf().fieldOf("chainedTo").forGetter(ChainData::getChainedTo)).apply((Applicative)i, ChainData::new));
    public static final class_9139<class_9129, ChainData> PACKET_CODEC = class_9135.method_56896(CODEC);
    @NotNull
    private final List<UUID> chainedTo = new LinkedList<UUID>();

    public ChainData() {
    }

    private ChainData(List<UUID> chainedTo) {
        this.chainedTo.addAll(chainedTo);
    }

    @Override
    public void tick(class_1309 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            for (UUID uuid : this.chainedTo) {
                double distance;
                class_1297 chain = world.method_14190(uuid);
                if (chain == null || !((distance = (double)chain.method_5739((class_1297)entity)) > 7.0)) continue;
                double x = (chain.method_23317() - entity.method_23317()) / distance;
                double y = (chain.method_23318() - entity.method_23318()) / distance;
                double z = (chain.method_23321() - entity.method_23321()) / distance;
                entity.method_18799(entity.method_18798().method_1031(x * Math.abs(x) * 0.4, y * Math.abs(y) * 0.2, z * Math.abs(z) * 0.4));
            }
        }
    }

    @NotNull
    public List<UUID> getChainedTo() {
        return List.copyOf(this.chainedTo);
    }

    public void clearChains() {
        this.chainedTo.clear();
        this.markDirty();
    }

    public void attachChain(UUID chain) {
        if (this.chainedTo.contains(chain)) {
            return;
        }
        this.chainedTo.add(chain);
        this.markDirty();
    }

    public void removeChain(UUID chain) {
        this.chainedTo.remove(chain);
        this.markDirty();
    }

    public boolean isChainedTo(UUID toCheck) {
        return this.chainedTo.contains(toCheck);
    }

    public static ChainData get(class_1309 living) {
        return ComponentManager.getChainData(living);
    }
}

