/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafWorld;
import com.iafenvoy.iceandfire.util.attachment.NeedUpdateData;
import com.iafenvoy.iceandfire.world.processor.DreadPortalProcessor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class PortalData
extends NeedUpdateData<class_1309> {
    public static final Codec<PortalData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("teleported").forGetter(PortalData::isTeleported), (App)Codec.INT.fieldOf("teleportTick").forGetter(PortalData::getTeleportTick)).apply((Applicative)i, PortalData::new));
    public static final class_9139<class_9129, PortalData> PACKET_CODEC = class_9135.method_56896(CODEC);
    private boolean teleported = false;
    private int teleportTick = -1;

    public PortalData() {
    }

    private PortalData(boolean teleported, int teleportTick) {
        this.teleported = teleported;
        this.teleportTick = teleportTick;
    }

    @Override
    public void tick(class_1309 living) {
        class_1937 world = living.method_37908();
        if (!this.isTeleported() && this.getTeleportTick() == 0 && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.setTeleported(true);
            MinecraftServer server = serverWorld.method_8503();
            if (world.method_27983().method_29177().equals((Object)IafWorld.DREAD_LAND.method_29177())) {
                living.method_5731(new class_5454(server.method_30002(), living.method_19538(), class_243.field_1353, living.field_6241, living.method_36455(), class_5454.field_52246));
            } else {
                class_3218 dreadLand = server.method_3847(IafWorld.DREAD_LAND);
                if (dreadLand == null) {
                    return;
                }
                living.method_5731(new class_5454(server.method_3847(IafWorld.DREAD_LAND), living.method_19538(), class_243.field_1353, living.field_6241, living.method_36455(), class_5454.field_52246));
                if (!dreadLand.method_8320(living.method_24515()).method_27852((class_2248)IafBlocks.DREAD_PORTAL.get())) {
                    server.method_27727().method_15094(class_2960.method_60655((String)"iceandfire", (String)"dread_exit_portal")).ifPresent(structureTemplate -> structureTemplate.method_15172((class_5425)dreadLand, living.method_24515().method_10059((class_2382)new class_2338(2, 1, 2)), class_2338.field_10980, new class_3492().method_16184((class_3491)new DreadPortalProcessor()), dreadLand.field_9229, 2));
                }
                living.method_43496((class_2561)class_2561.method_43471((String)"warning.iceandfire.dreadland.not_complete"));
            }
        }
        if (world.method_8320(living.method_24515()).method_27852((class_2248)IafBlocks.DREAD_PORTAL.get())) {
            if (this.getTeleportTick() > 0) {
                this.setTeleportTick(this.getTeleportTick() - 1);
            } else if (this.getTeleportTick() == -1) {
                this.setTeleportTick(100);
            }
        } else {
            this.setTeleported(false);
            this.setTeleportTick(-1);
        }
    }

    public boolean isTeleported() {
        return this.teleported;
    }

    public int getTeleportTick() {
        return this.teleportTick;
    }

    public void setTeleported(boolean teleported) {
        if (this.teleported != teleported) {
            this.markDirty();
        }
        this.teleported = teleported;
    }

    public void setTeleportTick(int teleportTick) {
        if (this.teleportTick != teleportTick) {
            this.markDirty();
        }
        this.teleportTick = teleportTick;
    }

    public static PortalData get(class_1657 player) {
        return ComponentManager.getPortalData(player);
    }
}

