/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.ai.PixieAIEnterHouseGoal;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFleeGoal;
import com.iafenvoy.iceandfire.entity.ai.PixieAIFollowOwnerGoal;
import com.iafenvoy.iceandfire.entity.ai.PixieAIMoveRandomGoal;
import com.iafenvoy.iceandfire.entity.ai.PixieAIPickupItemGoal;
import com.iafenvoy.iceandfire.entity.ai.PixieAIStealGoal;
import com.iafenvoy.iceandfire.item.block.entity.PixieHouseBlockEntity;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHouseS2CPayload;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.uranus.ServerHelper;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;

public class PixieEntity
extends class_1321 {
    public static final float[][] PARTICLE_RGB = new float[][]{{1.0f, 0.752f, 0.792f}, {0.831f, 0.662f, 1.0f}, {0.513f, 0.843f, 1.0f}, {0.654f, 0.909f, 0.615f}, {0.996f, 0.788f, 0.407f}};
    public static final int STEAL_COOLDOWN = 3000;
    private static final class_2940<Integer> COLOR = class_2945.method_12791(PixieEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> COMMAND = class_2945.method_12791(PixieEntity.class, (class_2941)class_2943.field_13327);
    public final class_6880<class_1291>[] positivePotions = new class_6880[]{class_1294.field_5910, class_1294.field_5913, class_1294.field_5904, class_1294.field_5926, class_1294.field_5917};
    public final class_6880<class_1291>[] negativePotions = new class_6880[]{class_1294.field_5911, class_1294.field_5916, class_1294.field_5909, class_1294.field_5908, class_1294.field_5901};
    public boolean slowSpeed = false;
    public int ticksUntilHouseAI;
    public int ticksHeldItemFor;
    public int stealCooldown = 0;
    private class_2338 housePos;
    private boolean isSitting;

    public PixieEntity(class_1299<? extends PixieEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6207 = new AIMoveControl(this);
        this.field_6194 = 3;
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    public static class_2338 getPositionRelativetoGround(class_1297 entity, class_1937 world, double x, double z, class_5819 rand) {
        class_2338 pos = class_2338.method_49637((double)x, (double)entity.method_31478(), (double)z);
        for (int yDown = 0; yDown < 3; ++yDown) {
            if (world.method_22347(pos.method_10087(yDown))) continue;
            return pos.method_10086(yDown);
        }
        return pos;
    }

    public static class_2338 findAHouse(class_1297 entity, class_1937 world) {
        for (int xSearch = -10; xSearch < 10; ++xSearch) {
            for (int ySearch = -10; ySearch < 10; ++ySearch) {
                for (int zSearch = -10; zSearch < 10; ++zSearch) {
                    class_2586 class_25862;
                    if (world.method_8321(entity.method_24515().method_10069(xSearch, ySearch, zSearch)) == null || !((class_25862 = world.method_8321(entity.method_24515().method_10069(xSearch, ySearch, zSearch))) instanceof PixieHouseBlockEntity)) continue;
                    PixieHouseBlockEntity house = (PixieHouseBlockEntity)class_25862;
                    if (house.hasPixie) continue;
                    return entity.method_24515().method_10069(xSearch, ySearch, zSearch);
                }
            }
        }
        return entity.method_24515();
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.25);
    }

    public boolean isPixieSitting() {
        if (this.method_37908().field_9236) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_6011.method_12789(field_6322) & 1) != 0;
            this.method_24346(isSitting);
            return isSitting;
        }
        return this.isSitting;
    }

    public void setPixieSitting(boolean sitting) {
        if (!this.method_37908().field_9236) {
            this.isSitting = sitting;
            this.method_6179(sitting);
        }
        byte b0 = (Byte)this.field_6011.method_12789(field_6322);
        if (sitting) {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 | 1)));
        } else {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean method_24345() {
        return this.isPixieSitting();
    }

    public int method_6110() {
        return 3;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8479);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236 && this.method_59922().method_43048(3) == 0 && !this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
            this.stealCooldown = 3000;
            return true;
        }
        if (this.isOwnerClose() && (source.method_5529() != null && source == this.method_37908().method_48963().method_48798(source.method_5529()) || source == this.method_37908().method_48963().method_48822() || this.method_35057() != null && source.method_5529() == this.method_35057())) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5679(class_1282 source) {
        class_1309 owner;
        boolean invulnerable = super.method_5679(source);
        if (!invulnerable && (owner = this.method_35057()) != null && source.method_5529() == owner) {
            return true;
        }
        return invulnerable;
    }

    public void method_6078(class_1282 cause) {
        if (!this.method_37908().field_9236 && !this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
        }
        super.method_6078(cause);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)0);
        builder.method_56912(COMMAND, (Object)0);
    }

    protected void method_6087(class_1297 entityIn) {
        if (this.method_35057() != entityIn) {
            entityIn.method_5697((class_1297)this);
        }
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_6171((class_1309)player)) {
            if (player.method_5998(hand).method_31573(IafItemTags.HEAL_PIXIE) && this.method_6032() < this.method_6063()) {
                this.method_6025(5.0f);
                player.method_5998(hand).method_7934(1);
                this.method_5783((class_3414)IafSounds.PIXIE_TAUNT.get(), 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() > 1) {
                this.setCommand(0);
            }
            return class_1269.field_5812;
        }
        if (player.method_5998(hand).method_7909() == ((class_2248)IafBlocks.JAR_EMPTY.get()).method_8389() && !this.method_6181()) {
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            class_2248 jar = switch (this.getColor()) {
                case 0 -> (class_2248)IafBlocks.JAR_PIXIE_0.get();
                case 1 -> (class_2248)IafBlocks.JAR_PIXIE_1.get();
                case 2 -> (class_2248)IafBlocks.JAR_PIXIE_2.get();
                case 3 -> (class_2248)IafBlocks.JAR_PIXIE_3.get();
                case 4 -> (class_2248)IafBlocks.JAR_PIXIE_4.get();
                default -> class_2246.field_10124;
            };
            class_1799 stack = new class_1799((class_1935)jar, 1);
            if (!this.method_37908().field_9236) {
                if (!this.method_5998(class_1268.field_5808).method_7960()) {
                    this.method_5699(this.method_5998(class_1268.field_5808), 0.0f);
                    this.stealCooldown = 3000;
                }
                this.method_5699(stack, 0.0f);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
        return super.method_5992(player, hand);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new PixieAIFollowOwnerGoal(this, 1.0, 2.0f, 4.0f));
        this.field_6201.method_6277(2, new PixieAIPickupItemGoal(this, false));
        this.field_6201.method_6277(2, new PixieAIFleeGoal<class_1657>(this, class_1657.class, 10.0f, (Predicate<class_1657>)((com.google.common.base.Predicate)entity -> true)));
        this.field_6201.method_6277(2, (class_1352)new PixieAIStealGoal(this));
        this.field_6201.method_6277(3, (class_1352)new PixieAIMoveRandomGoal(this));
        this.field_6201.method_6277(4, (class_1352)new PixieAIEnterHouseGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
        this.setColor(this.field_5974.method_43048(5));
        this.method_6122(class_1268.field_5808, class_1799.field_8037);
        return spawnDataIn;
    }

    private boolean isBeyondHeight() {
        if (this.method_23318() > (double)this.method_37908().method_31600()) {
            return true;
        }
        class_2338 height = this.method_37908().method_8598(class_2902.class_2903.field_13203, this.method_24515());
        int maxY = 20 + height.method_10264();
        return this.method_23318() > (double)maxY;
    }

    public int getCommand() {
        return (Integer)this.field_6011.method_12789(COMMAND);
    }

    public void setCommand(int command) {
        this.field_6011.method_12778(COMMAND, (Object)command);
        this.setPixieSitting(command == 1);
    }

    public void method_6007() {
        class_2586 class_25862;
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (this.isPixieSitting() && this.getCommand() != 1) {
                this.setPixieSitting(false);
            }
            if (!this.isPixieSitting() && this.getCommand() == 1) {
                this.setPixieSitting(true);
            }
            if (this.isPixieSitting()) {
                this.method_5942().method_6340();
            }
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        this.ticksHeldItemFor = !this.method_6047().method_7960() && !this.method_6181() ? ++this.ticksHeldItemFor : 0;
        if (!this.isPixieSitting() && !this.isBeyondHeight()) {
            this.method_18799(this.method_18798().method_1031(0.0, 0.08, 0.0));
        }
        if (this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)IafParticles.PIXIE_DUST.get(), this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), (double)PARTICLE_RGB[this.getColor()][0], (double)PARTICLE_RGB[this.getColor()][1], (double)PARTICLE_RGB[this.getColor()][2]);
        }
        if (this.ticksUntilHouseAI > 0) {
            --this.ticksUntilHouseAI;
        }
        if (!this.method_37908().field_9236 && this.housePos != null && this.method_5707(class_243.method_24953((class_2382)this.housePos)) < 1.5 && this.method_37908().method_8321(this.housePos) != null && (class_25862 = this.method_37908().method_8321(this.housePos)) instanceof PixieHouseBlockEntity) {
            PixieHouseBlockEntity house = (PixieHouseBlockEntity)class_25862;
            if (house.hasPixie) {
                this.housePos = null;
            } else {
                house.hasPixie = true;
                house.pixieType = this.getColor();
                house.pixieItems.set(0, (Object)this.method_5998(class_1268.field_5808));
                house.tamedPixie = this.method_6181();
                house.pixieOwnerUUID = this.method_6139();
                ServerHelper.sendToAll((class_8710)new UpdatePixieHouseS2CPayload(this.housePos, true, this.getColor()));
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
        if (this.method_35057() != null && this.isOwnerClose() && this.field_6012 % 80 == 0) {
            this.method_35057().method_6092(new class_1293(this.positivePotions[this.getColor()], 100, 0, false, false));
        }
    }

    public int getColor() {
        return class_3532.method_15340((int)((Integer)this.method_5841().method_12789(COLOR)), (int)0, (int)4);
    }

    public void setColor(int color) {
        this.method_5841().method_12778(COLOR, (Object)color);
    }

    public void method_5749(class_2487 compound) {
        this.setColor(compound.method_10550("Color"));
        this.stealCooldown = compound.method_10550("StealCooldown");
        this.ticksHeldItemFor = compound.method_10550("HoldingTicks");
        this.setPixieSitting(compound.method_10577("PixieSitting"));
        this.setCommand(compound.method_10550("Command"));
        super.method_5749(compound);
    }

    public void method_5652(class_2487 compound) {
        compound.method_10569("Color", this.getColor());
        compound.method_10569("Command", this.getCommand());
        compound.method_10569("StealCooldown", this.stealCooldown);
        compound.method_10569("HoldingTicks", this.ticksHeldItemFor);
        compound.method_10556("PixieSitting", this.isPixieSitting());
        super.method_5652(compound);
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    public void setHousePosition(class_2338 blockPos) {
        this.housePos = blockPos;
    }

    public class_2338 getHousePos() {
        return this.housePos;
    }

    public boolean isOwnerClose() {
        return this.method_6181() && this.method_35057() != null && this.method_5858((class_1297)this.method_35057()) < 100.0;
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.PIXIE_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)IafSounds.PIXIE_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.PIXIE_DIE.get();
    }

    public boolean method_5722(class_1297 entityIn) {
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                class_1321 tameable = (class_1321)entityIn;
                return tameable.method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    class AIMoveControl
    extends class_1335 {
        public AIMoveControl(PixieEntity pixie) {
            super((class_1308)pixie);
        }

        public void method_6240() {
            float speedMod = 1.0f;
            if (PixieEntity.this.slowSpeed) {
                speedMod = 2.0f;
            }
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                if (PixieEntity.this.field_5976) {
                    PixieEntity.this.method_36456(this.field_6371.method_36454() + 180.0f);
                    speedMod = 0.1f;
                    class_2338 target = PixieEntity.getPositionRelativetoGround((class_1297)PixieEntity.this, PixieEntity.this.method_37908(), PixieEntity.this.method_23317() + (double)PixieEntity.this.field_5974.method_43048(15) - 7.0, PixieEntity.this.method_23321() + (double)PixieEntity.this.field_5974.method_43048(15) - 7.0, PixieEntity.this.field_5974);
                    this.field_6370 = target.method_10263();
                    this.field_6369 = target.method_10264();
                    this.field_6367 = target.method_10260();
                }
                double d0 = this.field_6370 - PixieEntity.this.method_23317();
                double d1 = this.field_6369 - PixieEntity.this.method_23318();
                double d2 = this.field_6367 - PixieEntity.this.method_23321();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = Math.sqrt(d3)) < PixieEntity.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    PixieEntity.this.method_18799(PixieEntity.this.method_18798().method_18805(0.5, 0.5, 0.5));
                } else {
                    PixieEntity.this.method_18799(PixieEntity.this.method_18798().method_1031(d0 / d3 * 0.05 * this.field_6372 * (double)speedMod, d1 / d3 * 0.05 * this.field_6372 * (double)speedMod, d2 / d3 * 0.05 * this.field_6372 * (double)speedMod));
                    if (PixieEntity.this.method_5968() == null) {
                        PixieEntity.this.method_36456(-((float)class_3532.method_15349((double)PixieEntity.this.method_18798().field_1352, (double)PixieEntity.this.method_18798().field_1350)) * 57.295776f);
                        PixieEntity.this.field_6283 = PixieEntity.this.method_36454();
                    } else {
                        double d4 = PixieEntity.this.method_5968().method_23317() - PixieEntity.this.method_23317();
                        double d5 = PixieEntity.this.method_5968().method_23321() - PixieEntity.this.method_23321();
                        PixieEntity.this.method_36456(-((float)class_3532.method_15349((double)d4, (double)d5)) * 57.295776f);
                        PixieEntity.this.field_6283 = PixieEntity.this.method_36454();
                    }
                }
            }
        }
    }
}

