/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.IceDragonEntity;
import com.iafenvoy.iceandfire.util.IafMath;
import com.iafenvoy.uranus.object.item.FoodUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_3417;

public class DragonAITargetItemsGoal
extends class_1405 {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super class_1542> targetEntitySelector;
    private final int targetChance;
    private final boolean prioritizeItems;
    private final boolean isIce;
    protected class_1542 targetEntity;
    private List<class_1542> list = IafMath.emptyItemEntityList;

    public DragonAITargetItemsGoal(DragonBaseEntity creature, boolean checkSight) {
        this(creature, 20, checkSight, false, false);
    }

    public DragonAITargetItemsGoal(DragonBaseEntity creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, false);
    }

    public DragonAITargetItemsGoal(DragonBaseEntity creature, int chance, boolean checkSight, boolean onlyNearby) {
        this(creature, chance, checkSight, onlyNearby, false);
    }

    public DragonAITargetItemsGoal(DragonBaseEntity creature, int chance, boolean checkSight, boolean onlyNearby, boolean prioritizeItems) {
        super((class_1308)creature, checkSight, onlyNearby);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        this.isIce = creature instanceof IceDragonEntity;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((class_1297)creature);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.targetEntitySelector = item -> item != null && !item.method_6983().method_7960() && FoodUtils.getFoodPoints((class_1799)item.method_6983(), (boolean)true, (boolean)this.isIce) > 0;
        this.prioritizeItems = prioritizeItems;
    }

    public boolean method_6264() {
        DragonBaseEntity dragon = (DragonBaseEntity)this.field_6660;
        if (this.prioritizeItems && dragon.getHunger() >= 60) {
            return false;
        }
        if (dragon.getHunger() >= 100 || !dragon.canMove() || this.targetChance > 0 && this.field_6660.method_59922().method_43048(10) != 0) {
            this.list = IafMath.emptyItemEntityList;
            return false;
        }
        return this.updateList();
    }

    private boolean updateList() {
        if (this.field_6660.method_37908().method_8510() % 4L == 0L) {
            this.list = this.field_6660.method_37908().method_8390(class_1542.class, this.getTargetableArea(this.method_6326()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.getFirst();
        return true;
    }

    protected class_238 getTargetableArea(double targetDistance) {
        return this.field_6660.method_5829().method_1009(targetDistance, 4.0, targetDistance);
    }

    public void method_6269() {
        this.field_6660.method_5942().method_6337(this.targetEntity.method_23317(), this.targetEntity.method_23318(), this.targetEntity.method_23321(), 1.0);
        super.method_6269();
    }

    public void method_6268() {
        DragonBaseEntity dragon;
        class_1308 class_13082;
        super.method_6268();
        class_1799 stack = this.targetEntity.method_6983();
        if (this.targetEntity == null || !this.targetEntity.method_5805() || stack.method_7960()) {
            this.method_6270();
        } else if (this.field_6660.method_5858((class_1297)this.targetEntity) < (double)(this.field_6660.method_17681() * 2.0f + this.field_6660.method_17682() / 2.0f) || (class_13082 = this.field_6660) instanceof DragonBaseEntity && (dragon = (DragonBaseEntity)class_13082).getHeadPosition().method_1025(this.targetEntity.method_19538()) < (double)this.field_6660.method_17682()) {
            this.field_6660.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            int hunger = FoodUtils.getFoodPoints((class_1799)this.targetEntity.method_6983(), (boolean)true, (boolean)this.isIce);
            DragonBaseEntity dragon2 = (DragonBaseEntity)this.field_6660;
            dragon2.setHunger(Math.min(100, dragon2.getHunger() + hunger));
            this.targetEntity.method_6983();
            this.field_6660.method_6033(Math.min(this.field_6660.method_6063(), (float)((int)(this.field_6660.method_6032() + (float)FoodUtils.getFoodPoints((class_1799)this.targetEntity.method_6983(), (boolean)true, (boolean)this.isIce)))));
            if (DragonBaseEntity.ANIMATION_EAT != null) {
                dragon2.setAnimation(DragonBaseEntity.ANIMATION_EAT);
            }
            for (int i = 0; i < 4; ++i) {
                dragon2.spawnItemCrackParticles(stack.method_7909());
            }
            this.targetEntity.method_6983().method_7934(1);
            this.method_6270();
        } else {
            this.updateList();
        }
    }

    public boolean method_6266() {
        return !this.field_6660.method_5942().method_6357();
    }

    public static class Sorter
    implements Comparator<class_1297> {
        private final class_1297 theEntity;

        public Sorter(class_1297 theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(class_1297 p_compare_1_, class_1297 p_compare_2_) {
            double d0 = this.theEntity.method_5858(p_compare_1_);
            double d1 = this.theEntity.method_5858(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

