/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.HippogryphEntity;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItemsGoal;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.util.IafMath;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1405;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_3417;

public class HippogryphAITargetItemsGoal<T extends class_1542>
extends class_1405 {
    protected final DragonAITargetItemsGoal.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super class_1542> targetEntitySelector;
    protected final int targetChance;
    protected class_1542 targetEntity;
    private List<class_1542> list = IafMath.emptyItemEntityList;

    public HippogryphAITargetItemsGoal(class_1308 creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public HippogryphAITargetItemsGoal(class_1308 creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public HippogryphAITargetItemsGoal(class_1308 creature, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItemsGoal.Sorter((class_1297)creature);
        this.targetChance = chance;
        this.targetEntitySelector = item -> item != null && !item.method_6983().method_7960() && item.method_6983().method_31573(IafItemTags.TAME_HIPPOGRYPH);
    }

    public boolean method_6264() {
        if (this.targetChance > 0 && this.field_6660.method_59922().method_43048(this.targetChance) != 0) {
            return false;
        }
        if (!((HippogryphEntity)this.field_6660).canMove()) {
            this.list = IafMath.emptyItemEntityList;
            return false;
        }
        return this.updateList();
    }

    private boolean updateList() {
        this.list = this.field_6660.method_37908().method_8390(class_1542.class, this.getTargetableArea(this.method_6326()), this.targetEntitySelector);
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.getFirst();
        return true;
    }

    protected class_238 getTargetableArea(double targetDistance) {
        return this.field_6660.method_5829().method_1009(targetDistance, 4.0, targetDistance);
    }

    public void method_6269() {
        this.field_6660.method_5942().method_6337(this.targetEntity.method_23317(), this.targetEntity.method_23318(), this.targetEntity.method_23321(), 1.0);
        super.method_6269();
    }

    public void method_6268() {
        super.method_6268();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            this.method_6270();
        } else if (this.getAttackReachSqr((class_1297)this.targetEntity) >= this.field_6660.method_5858((class_1297)this.targetEntity)) {
            class_1297 class_12972;
            HippogryphEntity hippo = (HippogryphEntity)this.field_6660;
            this.targetEntity.method_6983().method_7934(1);
            this.field_6660.method_5783(class_3417.field_20614, 1.0f, 1.0f);
            hippo.setAnimation(HippogryphEntity.ANIMATION_EAT);
            ++hippo.feedings;
            hippo.method_6025(4.0f);
            if (hippo.feedings > 3 && (hippo.feedings > 7 || hippo.method_59922().method_43048(3) == 0) && !hippo.method_6181() && (class_12972 = this.targetEntity.method_24921()) instanceof class_1657) {
                class_1657 owner = (class_1657)class_12972;
                hippo.method_6170(owner);
                hippo.method_5980(null);
                hippo.setCommand(1);
                hippo.method_24346(true);
            }
            this.method_6270();
        } else {
            this.updateList();
        }
    }

    public boolean method_6266() {
        return !this.field_6660.method_5942().method_6357();
    }

    protected double getAttackReachSqr(class_1297 attackTarget) {
        return this.field_6660.method_17681() * 2.0f * this.field_6660.method_17681() * 2.0f + attackTarget.method_17681();
    }

    public static class Sorter
    implements Comparator<class_1297> {
        private final class_1297 theEntity;

        public Sorter(class_1297 theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(class_1297 p_compare_1_, class_1297 p_compare_2_) {
            double d0 = this.theEntity.method_5858(p_compare_1_);
            double d1 = this.theEntity.method_5858(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

