/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.data.component.MiscData;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.network.payload.DragonControlC2SPayload;
import com.iafenvoy.iceandfire.registry.IafKeybindings;
import com.iafenvoy.iceandfire.registry.IafStatusEffects;
import com.iafenvoy.iceandfire.render.misc.ChainRenderer;
import com.iafenvoy.iceandfire.render.misc.CockatriceBeamRenderer;
import com.iafenvoy.iceandfire.render.misc.FrozenStateRenderer;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_5577;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public final class ClientEvents {
    public static int currentView = 0;
    public static final CopyOnWriteArrayList<class_3545<class_243, class_243>> LIGHTNINGS = new CopyOnWriteArrayList();

    public static void onCameraSetup(class_4184 camera) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_5854() instanceof DragonBaseEntity) {
            float scale = ((DragonBaseEntity)player.method_5854()).getRenderSize() / 3.0f;
            if (class_310.method_1551().field_1690.method_31044() == class_5498.field_26665 || class_310.method_1551().field_1690.method_31044() == class_5498.field_26666) {
                if (currentView == 1) {
                    camera.method_19324(-camera.method_19318(scale * 1.2f), 0.0f, 0.0f);
                } else if (currentView == 2) {
                    camera.method_19324(-camera.method_19318(scale * 3.0f), 0.0f, 0.0f);
                } else if (currentView == 3) {
                    camera.method_19324(-camera.method_19318(scale * 5.0f), 0.0f, 0.0f);
                }
            }
        }
    }

    public static void onLivingUpdate(class_1309 entity) {
        class_1297 controlState2;
        class_1657 player;
        class_310 mc = class_310.method_1551();
        if (entity instanceof ICustomMoveController) {
            ICustomMoveController moveController = (ICustomMoveController)entity;
            if (entity.method_5854() != null && entity.method_5854() == mc.field_1724) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.field_1690.field_1832.method_1434());
                byte controlState2 = moveController.getControlState();
                if (controlState2 != previousState) {
                    NetworkManager.sendToServer((class_8710)new DragonControlC2SPayload(entity.method_5628(), controlState2, entity.method_24515()));
                }
            }
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity) == class_310.method_1551().field_1724 && (controlState2 = player.method_5854()) instanceof ICustomMoveController) {
            ICustomMoveController controller = (ICustomMoveController)controlState2;
            class_1297 vehicle = player.method_5854();
            byte previousState = controller.getControlState();
            controller.up(mc.field_1690.field_1903.method_1434());
            controller.down(IafKeybindings.DRAGON_DOWN.method_1434());
            controller.attack(IafKeybindings.DRAGON_STRIKE.method_1434());
            controller.dismount(mc.field_1690.field_1832.method_1434());
            controller.strike(IafKeybindings.DRAGON_BREATH.method_1434());
            byte controlState3 = controller.getControlState();
            if (controlState3 != previousState) {
                NetworkManager.sendToServer((class_8710)new DragonControlC2SPayload(vehicle.method_5628(), controlState3, vehicle.method_24515()));
            }
        }
    }

    public static void onPostRenderLiving(class_1309 entity, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) {
        MiscData miscData = MiscData.get(entity);
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        miscData.checkScepterTarget(arg_0 -> ((class_5577)world.field_27734.method_31866()).method_31808(arg_0));
        for (UUID target : miscData.getTargetedByScepters()) {
            CockatriceBeamRenderer.render((class_1297)entity, (class_1297)world.field_27734.method_31866().method_31808(target), matrixStack, buffers, partialRenderTick);
        }
        class_1293 effect = entity.method_6112(class_7923.field_41174.method_47983((Object)((class_1291)IafStatusEffects.FROZEN.get())));
        if (effect != null) {
            FrozenStateRenderer.render(entity, matrixStack, buffers, light, effect.method_5584());
        }
        ChainData chainData = ChainData.get(entity);
        ChainRenderer.render(entity, matrixStack, buffers, light, chainData.getChainedTo());
    }
}

