/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.item.component.DragonHornComponent;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class DragonHornItem
extends class_1792 {
    public DragonHornItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static int getDragonType(class_1799 stack) {
        Optional optional;
        if (stack.method_57826((class_9331)IafDataComponents.DRAGON_HORN.get()) && (optional = class_7923.field_41177.method_17966(((DragonHornComponent)stack.method_57824((class_9331)IafDataComponents.DRAGON_HORN.get())).entityType())).isPresent()) {
            class_1299 entityType = (class_1299)optional.get();
            if (entityType == IafEntities.FIRE_DRAGON.get()) {
                return 1;
            }
            if (entityType == IafEntities.ICE_DRAGON.get()) {
                return 2;
            }
            if (entityType == IafEntities.LIGHTNING_DRAGON.get()) {
                return 3;
            }
        }
        return 0;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        stack = player.method_5998(hand);
        if (stack.method_31574((class_1792)IafItems.DRAGON_HORN.get()) && !stack.method_57826((class_9331)IafDataComponents.DRAGON_HORN.get())) {
            DragonBaseEntity dragon;
            class_1309 class_13092;
            if (!player.method_37908().field_9236 && (class_13092 = target) instanceof DragonBaseEntity && (dragon = (DragonBaseEntity)class_13092).method_6171((class_1309)player)) {
                class_2487 entityTag = new class_2487();
                target.method_5662(entityTag);
                stack.method_57379((class_9331)IafDataComponents.DRAGON_HORN.get(), (Object)new DragonHornComponent(class_7923.field_41177.method_10221((Object)target.method_5864()), target.method_5667(), entityTag));
                player.method_6104(hand);
                player.method_37908().method_8396(player, player.method_24515(), class_3417.field_15168, class_3419.field_15254, 3.0f, 0.75f);
                target.method_5650(class_1297.class_5529.field_26999);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8038() != class_2350.field_11036) {
            return class_1269.field_5811;
        }
        class_1799 stack = context.method_8041();
        if (stack.method_57826((class_9331)IafDataComponents.DRAGON_HORN.get())) {
            DragonHornComponent component = (DragonHornComponent)stack.method_57824((class_9331)IafDataComponents.DRAGON_HORN.get());
            class_1937 world = context.method_8045();
            class_1299 type = class_7923.field_41177.method_17966(component.entityType()).orElse(null);
            if (type != null) {
                UUID uuid;
                class_1297 entity = type.method_5883(world);
                if (entity instanceof DragonBaseEntity) {
                    DragonBaseEntity dragon = (DragonBaseEntity)entity;
                    dragon.method_5651(component.entityData());
                }
                if ((uuid = component.entityUuid()) != null) {
                    assert (entity != null);
                    entity.method_5826(uuid);
                }
                assert (entity != null);
                entity.method_5641((double)context.method_8037().method_10263() + 0.5, (double)(context.method_8037().method_10264() + 1), (double)context.method_8037().method_10260() + 0.5, 180.0f + context.method_8042().method_10144(), 0.0f);
                if (world.method_8649(entity)) {
                    stack.method_57381((class_9331)IafDataComponents.DRAGON_HORN.get());
                }
            }
        }
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        Optional optional;
        DragonHornComponent component;
        class_2487 entityTag;
        super.method_7851(stack, context, tooltip, type);
        if (stack.method_57826((class_9331)IafDataComponents.DRAGON_HORN.get()) && !(entityTag = (component = (DragonHornComponent)stack.method_57824((class_9331)IafDataComponents.DRAGON_HORN.get())).entityData()).method_33133() && (optional = class_7923.field_41177.method_17966(component.entityType())).isPresent()) {
            class_1299 entityType = (class_1299)optional.get();
            tooltip.add((class_2561)class_2561.method_43471((String)entityType.method_5882()).method_27692(this.getTextColorForEntityType(entityType)));
            String name = class_2561.method_43471((String)"dragon.unnamed").getString();
            if (!entityTag.method_10558("CustomName").isEmpty()) {
                name = entityTag.method_10558("CustomName");
            }
            tooltip.add((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1080));
            String gender = class_2561.method_43471((String)"dragon.gender").getString() + " " + class_2561.method_43471((String)(entityTag.method_10577("Gender") ? "dragon.gender.male" : "dragon.gender.female")).getString();
            tooltip.add((class_2561)class_2561.method_43470((String)gender).method_27692(class_124.field_1080));
            int stagenumber = entityTag.method_10550("AgeTicks") / 24000;
            int stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            tooltip.add((class_2561)class_2561.method_43471((String)"dragon.stage").method_10852((class_2561)class_2561.method_43470((String)(" " + stage1 + " "))).method_10852((class_2561)class_2561.method_43471((String)"dragon.days.front")).method_10852((class_2561)class_2561.method_43470((String)(stagenumber + " "))).method_10852((class_2561)class_2561.method_43471((String)"dragon.days.back")).method_27692(class_124.field_1080));
        }
    }

    private class_124 getTextColorForEntityType(class_1299<?> type) {
        if (type == IafEntities.FIRE_DRAGON.get()) {
            return class_124.field_1079;
        }
        if (type == IafEntities.ICE_DRAGON.get()) {
            return class_124.field_1078;
        }
        if (type == IafEntities.LIGHTNING_DRAGON.get()) {
            return class_124.field_1064;
        }
        return class_124.field_1080;
    }
}

