/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.world.DragonPosWorldData;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_9331;

public class SummoningCrystalItem
extends class_1792 {
    public SummoningCrystalItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static boolean hasDragon(class_1799 stack) {
        class_2487 nbt = (class_2487)stack.method_57824((class_9331)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
        if (stack.method_7909() instanceof SummoningCrystalItem && nbt != null) {
            for (String tagInfo : nbt.method_10541()) {
                if (!tagInfo.contains("Dragon")) continue;
                return true;
            }
        }
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_2487 nbt;
        super.method_7851(stack, context, tooltip, type);
        boolean flag = false;
        String desc = "entity.iceandfire.fire_dragon";
        if (stack.method_7909() == IafItems.SUMMONING_CRYSTAL_ICE.get()) {
            desc = "entity.iceandfire.ice_dragon";
        }
        if (stack.method_7909() == IafItems.SUMMONING_CRYSTAL_LIGHTNING.get()) {
            desc = "entity.iceandfire.lightning_dragon";
        }
        if ((nbt = (class_2487)stack.method_57824((class_9331)IafDataComponents.CRYSTAL_DRAGON_DATA.get())) != null) {
            for (String tagInfo : nbt.method_10541()) {
                if (!tagInfo.contains("Dragon")) continue;
                class_2487 dragonTag = nbt.method_10562(tagInfo);
                String dragonName = class_1074.method_4662((String)desc, (Object[])new Object[0]);
                if (!dragonTag.method_10558("CustomName").isEmpty()) {
                    dragonName = dragonTag.method_10558("CustomName");
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"item.iceandfire.summoning_crystal.bound", (Object[])new Object[]{dragonName}).method_27692(class_124.field_1080));
                flag = true;
            }
        }
        if (!flag) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.iceandfire.summoning_crystal.desc_0").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.iceandfire.summoning_crystal.desc_1").method_27692(class_124.field_1080));
        }
    }

    public class_1269 method_7884(class_1838 context) {
        assert (context.method_8036() != null);
        class_1799 stack = context.method_8036().method_5998(context.method_20287());
        boolean flag = false;
        class_2338 offsetPos = context.method_8037().method_10093(context.method_8038());
        float yaw = context.method_8036().method_36454();
        boolean displayError = false;
        class_2487 nbt = (class_2487)stack.method_57824((class_9331)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
        if (nbt != null && stack.method_7909() == this && SummoningCrystalItem.hasDragon(stack)) {
            for (String tagInfo : nbt.method_10541()) {
                class_2487 dragonTag;
                UUID id;
                if (!tagInfo.contains("Dragon") || (id = (dragonTag = nbt.method_10562(tagInfo)).method_25926("DragonUUID")) == null || context.method_8045().field_9236) continue;
                try {
                    class_1297 entity = context.method_8045().method_8503().method_3847(context.method_8036().method_37908().method_27983()).method_14190(id);
                    if (entity != null) {
                        flag = true;
                        this.summonEntity(entity, context.method_8045(), offsetPos, yaw);
                    }
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.error((Object)e);
                    displayError = true;
                }
                DragonPosWorldData data = DragonPosWorldData.get(context.method_8045());
                class_2338 dragonChunkPos = null;
                if (data != null) {
                    dragonChunkPos = data.getDragonPos(id);
                }
                if (!((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue()) continue;
                try {
                    if (flag || data == null || !context.method_8045().field_9236) continue;
                    class_3218 serverWorld = (class_3218)context.method_8045();
                    class_1923 pos = new class_1923(dragonChunkPos);
                    serverWorld.method_17988(pos.field_9181, pos.field_9180, true);
                }
                catch (Exception e) {
                    IceAndFire.LOGGER.warn("Could not load chunk when summoning dragon", (Throwable)e);
                }
            }
            if (flag) {
                context.method_8036().method_5783(class_3417.field_14879, 1.0f, 1.0f);
                context.method_8036().method_5783(class_3417.field_15081, 1.0f, 1.0f);
                context.method_8036().method_6104(context.method_20287());
                context.method_8036().method_7353((class_2561)class_2561.method_43471((String)"message.iceandfire.dragonTeleport"), true);
                stack.method_57381((class_9331)IafDataComponents.CRYSTAL_DRAGON_DATA.get());
            } else if (displayError) {
                context.method_8036().method_7353((class_2561)class_2561.method_43471((String)"message.iceandfire.noDragonTeleport"), true);
            }
        }
        return class_1269.field_5811;
    }

    public void summonEntity(class_1297 entity, class_1937 worldIn, class_2338 offsetPos, float yaw) {
        DragonPosWorldData data;
        entity.method_5808((double)offsetPos.method_10263() + 0.5, (double)offsetPos.method_10264() + 0.5, (double)offsetPos.method_10260() + 0.5, yaw, 0.0f);
        if (entity instanceof DragonBaseEntity) {
            DragonBaseEntity dragon = (DragonBaseEntity)entity;
            dragon.setCrystalBound(false);
        }
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue() && (data = DragonPosWorldData.get(worldIn)) != null) {
            data.removeDragon(entity.method_5667());
        }
    }
}

