/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBlockEntity;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBrickBlockEntity;
import com.iafenvoy.iceandfire.item.block.util.DragonProof;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class DragonForgeBrickBlock
extends class_2237
implements DragonProof,
DragonTypeProvider {
    private static final Map<DragonType, class_2248> TYPE_MAP = new HashMap<DragonType, class_2248>();
    public static final class_2746 GRILL = class_2746.method_11825((String)"grill");
    private final DragonType dragonType;

    public DragonForgeBrickBlock(DragonType dragonType) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_51368(class_2766.field_12653).method_9624().method_9629(40.0f, 500.0f).method_9626(class_2498.field_11533));
        this.dragonType = dragonType;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)GRILL, (Comparable)Boolean.FALSE));
        TYPE_MAP.put(dragonType, (class_2248)this);
    }

    public static String name(DragonType dragonType) {
        return "dragonforge_%s_brick".formatted(dragonType.name());
    }

    public static class_2248 getBlockByType(DragonType type) {
        return TYPE_MAP.getOrDefault(type, (class_2248)IafBlocks.DRAGONFORGE_FIRE_BRICK.get());
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        DragonForgeBlockEntity forge = this.getConnectedBlockEntity(world, pos);
        if (forge != null && forge.getDragonType() == this.dragonType && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)forge);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private DragonForgeBlockEntity getConnectedBlockEntity(class_1937 worldIn, class_2338 pos) {
        for (class_2350 facing : class_2350.values()) {
            DragonForgeBlockEntity forge;
            class_2586 class_25862;
            if (worldIn.method_8321(pos.method_10093(facing)) == null || !((class_25862 = worldIn.method_8321(pos.method_10093(facing))) instanceof DragonForgeBlockEntity) || !(forge = (DragonForgeBlockEntity)class_25862).assembled()) continue;
            return forge;
        }
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{GRILL});
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return MapCodec.unit((Object)this);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DragonForgeBrickBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : DragonForgeBrickBlock.method_31618(type, (class_2591)((class_2591)IafBlockEntities.DRAGONFORGE_BRICK.get()), DragonForgeBrickBlockEntity::tick);
    }

    @Override
    public DragonType getDragonType() {
        return this.dragonType;
    }
}

