/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.block.DragonForgeBrickBlock;
import com.iafenvoy.iceandfire.item.block.DragonForgeCoreBlock;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.screen.handler.DragonForgeScreenHandler;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class DragonForgeBlockEntity
extends class_2624
implements class_1278,
ExtendedMenuProvider {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    public int lastDragonFlameTimer = 0;
    private class_2371<class_1799> forgeItemStacks = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;
    private int cookTime = 0;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> DragonForgeBlockEntity.this.cookTime;
                case 1 -> DragonForgeBlockEntity.this.getMaxCookTime();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                DragonForgeBlockEntity.this.cookTime = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public DragonForgeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)IafBlockEntities.DRAGONFORGE_CORE.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, DragonForgeBlockEntity blockEntity) {
        boolean flag = blockEntity.isBurning();
        boolean flag1 = false;
        if (blockEntity.lastDragonFlameTimer > 0) {
            --blockEntity.lastDragonFlameTimer;
        }
        blockEntity.updateGrills(blockEntity.assembled());
        if (!level.field_9236) {
            class_2248 class_22482;
            if (blockEntity.prevAssembled != blockEntity.assembled() && (class_22482 = state.method_26204()) instanceof DragonForgeCoreBlock) {
                DragonForgeCoreBlock core = (DragonForgeCoreBlock)class_22482;
                DragonForgeCoreBlock.setState(core.getDragonType(), level, pos);
            }
            blockEntity.prevAssembled = blockEntity.assembled();
            if (!blockEntity.assembled()) {
                return;
            }
        }
        if (blockEntity.cookTime > 0 && blockEntity.canSmelt() && blockEntity.lastDragonFlameTimer == 0) {
            --blockEntity.cookTime;
        }
        if (blockEntity.method_5438(0).method_7960() && !level.field_9236) {
            blockEntity.cookTime = 0;
        }
        assert (blockEntity.field_11863 != null);
        if (!blockEntity.field_11863.field_9236) {
            if (blockEntity.isBurning()) {
                if (blockEntity.canSmelt()) {
                    ++blockEntity.cookTime;
                    if (blockEntity.cookTime >= blockEntity.getMaxCookTime()) {
                        blockEntity.cookTime = 0;
                        blockEntity.smeltItem();
                        flag1 = true;
                    }
                } else if (blockEntity.cookTime > 0) {
                    blockEntity.lastDragonFlameTimer = 40;
                    blockEntity.cookTime = 0;
                }
            } else if (!blockEntity.isBurning() && blockEntity.cookTime > 0) {
                blockEntity.cookTime = class_3532.method_15340((int)(blockEntity.cookTime - 2), (int)0, (int)blockEntity.getMaxCookTime());
            }
            if (flag != blockEntity.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            blockEntity.method_5431();
        }
        if (!blockEntity.canAddFlameAgain) {
            blockEntity.canAddFlameAgain = true;
        }
    }

    public int method_5439() {
        return this.forgeItemStacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.forgeItemStacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            class_2338 pos = this.method_11016().method_10093(facing);
            assert (this.field_11863 != null);
            class_2680 state = this.field_11863.method_8320(pos);
            if (!state.method_28498((class_2769)DragonForgeBrickBlock.GRILL) || (Boolean)state.method_11654((class_2769)DragonForgeBrickBlock.GRILL) == grill) continue;
            this.field_11863.method_8501(pos, (class_2680)state.method_11657((class_2769)DragonForgeBrickBlock.GRILL, (Comparable)Boolean.valueOf(grill)));
        }
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.forgeItemStacks.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.forgeItemStacks, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.forgeItemStacks, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 itemstack = (class_1799)this.forgeItemStacks.get(index);
        boolean flag = !stack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)itemstack) && class_1799.method_7973((class_1799)stack, (class_1799)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (index == 0 && !flag || this.cookTime > this.getMaxCookTime()) {
            this.cookTime = 0;
            this.method_5431();
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.forgeItemStacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.forgeItemStacks, (class_7225.class_7874)registryLookup);
        this.cookTime = nbt.method_10550("CookTime");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("CookTime", (int)((short)this.cookTime));
        class_1262.method_5426((class_2487)nbt, this.forgeItemStacks, (class_7225.class_7874)registryLookup);
    }

    public int method_5444() {
        return 64;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public DragonType getDragonType() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof DragonTypeProvider) {
            DragonTypeProvider provider = (DragonTypeProvider)class_22482;
            return provider.getDragonType();
        }
        return IafDragonTypes.FIRE;
    }

    public int getFireType(class_2248 block) {
        if (block == IafBlocks.DRAGONFORGE_FIRE_CORE.get() || block == IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()) {
            return 0;
        }
        if (block == IafBlocks.DRAGONFORGE_ICE_CORE.get() || block == IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()) {
            return 1;
        }
        if (block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get() || block == IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()) {
            return 2;
        }
        return 0;
    }

    public int getMaxCookTime() {
        return this.getCurrentRecipe().map(DragonForgeRecipe::getCookTime).orElse(100);
    }

    private class_2248 getDefaultOutput() {
        return this.getDragonType() == IafDragonTypes.ICE ? (class_2248)IafBlocks.DRAGON_ICE.get() : (class_2248)IafBlocks.ASH.get();
    }

    private class_1799 getCurrentResult() {
        Optional<DragonForgeRecipe> recipe = this.getCurrentRecipe();
        return recipe.map(DragonForgeRecipe::getResultItem).orElseGet(() -> new class_1799((class_1935)this.getDefaultOutput()));
    }

    public Optional<DragonForgeRecipe> getCurrentRecipe() {
        assert (this.field_11863 != null);
        return this.field_11863.method_8433().method_8132((class_3956)IafRecipes.DRAGON_FORGE_TYPE.get(), (class_9695)new DragonForgeRecipeInput(this), this.field_11863).map(class_8786::comp_1933);
    }

    public List<DragonForgeRecipe> getRecipes() {
        assert (this.field_11863 != null);
        return this.field_11863.method_8433().method_30027((class_3956)IafRecipes.DRAGON_FORGE_TYPE.get()).stream().map(class_8786::comp_1933).toList();
    }

    public boolean canSmelt() {
        class_1799 cookStack = (class_1799)this.forgeItemStacks.getFirst();
        if (cookStack.method_7960()) {
            return false;
        }
        class_1799 forgeRecipeOutput = this.getCurrentResult();
        if (forgeRecipeOutput.method_7960()) {
            return false;
        }
        class_1799 outputStack = (class_1799)this.forgeItemStacks.get(2);
        if (!outputStack.method_7960() && !class_1799.method_7984((class_1799)outputStack, (class_1799)forgeRecipeOutput)) {
            return false;
        }
        int calculatedOutputCount = outputStack.method_7947() + forgeRecipeOutput.method_7947();
        return calculatedOutputCount <= this.method_5444() && calculatedOutputCount <= outputStack.method_7914();
    }

    public boolean method_5443(class_1657 player) {
        if (player.method_37908().method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        class_1799 cookStack = (class_1799)this.forgeItemStacks.get(0);
        class_1799 bloodStack = (class_1799)this.forgeItemStacks.get(1);
        class_1799 outputStack = (class_1799)this.forgeItemStacks.get(2);
        class_1799 output = this.getCurrentResult();
        if (outputStack.method_7960()) {
            this.forgeItemStacks.set(2, (Object)output.method_7972());
        } else {
            outputStack.method_7933(output.method_7947());
        }
        cookStack.method_7934(1);
        bloodStack.method_7934(1);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return switch (index) {
            case 1 -> this.getRecipes().stream().anyMatch(item -> item.isValidBlood(stack));
            case 0 -> true;
            default -> false;
        };
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return SLOTS_BOTTOM;
        }
        return side == class_2350.field_11036 ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean method_5492(int index, class_1799 itemStackIn, class_2350 direction) {
        return this.method_5437(index, itemStackIn);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033 && index == 1) {
            class_1792 item = stack.method_7909();
            return item == class_1802.field_8705 || item == class_1802.field_8550;
        }
        return true;
    }

    public void method_5448() {
        this.forgeItemStacks.clear();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)("container.dragonforge_fire" + this.getDragonType().name()));
    }

    protected class_2371<class_1799> method_11282() {
        return this.forgeItemStacks;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.forgeItemStacks = inventory;
    }

    public void transferPower(int i) {
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236) {
            if (this.canSmelt()) {
                if (this.canAddFlameAgain) {
                    this.cookTime = Math.min(this.getMaxCookTime() + 1, this.cookTime + i);
                    this.canAddFlameAgain = false;
                }
            } else {
                this.cookTime = 0;
            }
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095().method_10078(), (class_2248)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.method_10095().method_10067(), (class_2248)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.method_10072().method_10078(), (class_2248)IafBlocks.DRAGON_BONE_BLOCK.get()) && this.doesBlockEqual(pos.method_10072().method_10067(), (class_2248)IafBlocks.DRAGON_BONE_BLOCK.get());
    }

    private boolean checkBrickCorners(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095().method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10095().method_10067(), this.getBrick()) && this.doesBlockEqual(pos.method_10072().method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10072().method_10067(), this.getBrick());
    }

    private boolean checkBrickSlots(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10095(), this.getBrick()) && this.doesBlockEqual(pos.method_10078(), this.getBrick()) && this.doesBlockEqual(pos.method_10067(), this.getBrick()) && this.doesBlockEqual(pos.method_10072(), this.getBrick());
    }

    private boolean checkY(class_2338 pos) {
        return this.doesBlockEqual(pos.method_10084(), this.getBrick()) && this.doesBlockEqual(pos.method_10074(), this.getBrick());
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38242(registryLookup);
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.field_11867.method_10074()) && this.checkBrickSlots(this.field_11867.method_10074()) && this.checkBrickCorners(this.field_11867) && this.atleastThreeAreBricks(this.field_11867) && this.checkY(this.field_11867) && this.checkBoneCorners(this.field_11867.method_10084()) && this.checkBrickSlots(this.field_11867.method_10084());
    }

    private class_2248 getBrick() {
        return DragonForgeBrickBlock.getBlockByType(this.getDragonType());
    }

    private boolean doesBlockEqual(class_2338 pos, class_2248 block) {
        assert (this.field_11863 != null);
        return this.field_11863.method_8320(pos).method_26204() == block;
    }

    private boolean atleastThreeAreBricks(class_2338 pos) {
        int count = 0;
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            assert (this.field_11863 != null);
            if (this.field_11863.method_8320(pos.method_10093(facing)).method_26204() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new DragonForgeScreenHandler(id, (class_1263)this, player, this.getDragonType(), this.delegate);
    }

    public void saveExtraData(class_2540 buf) {
        Optional key = IafRegistries.DRAGON_TYPE.method_29113((Object)this.getDragonType());
        key.ifPresent(arg_0 -> ((class_2540)buf).method_44116(arg_0));
    }

    public static class DragonForgeRecipeInput
    implements class_9695 {
        private final DragonForgeBlockEntity owner;

        public DragonForgeRecipeInput(DragonForgeBlockEntity owner) {
            this.owner = owner;
        }

        public class_1799 method_59984(int slot) {
            return (class_1799)this.owner.forgeItemStacks.get(slot);
        }

        public int method_59983() {
            return this.owner.forgeItemStacks.size();
        }

        public class_1799 getStack(int index) {
            return (class_1799)this.owner.forgeItemStacks.get(index);
        }

        public String getTypeID() {
            return switch (this.owner.getFireType(this.owner.method_11010().method_26204())) {
                case 0 -> "fire";
                case 1 -> "ice";
                case 2 -> "lightning";
                default -> "";
            };
        }
    }
}

