/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.item.block.DragonForgeInputBlock;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeBlockEntity;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafDragonTypes;
import com.iafenvoy.iceandfire.util.DragonTypeProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7225;

public class DragonForgeInputBlockEntity
extends class_2586 {
    private static final int LURE_DISTANCE = 50;
    private int ticksSinceDragonFire;
    private DragonForgeBlockEntity core = null;

    public DragonForgeInputBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)IafBlockEntities.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 position, class_2680 state, DragonForgeInputBlockEntity forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            class_2586 tileentity = level.method_8321(position);
            level.method_8501(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.method_10996();
                level.method_8438(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38242(registryLookup);
    }

    protected void lureDragons() {
        class_243 targetPosition = new class_243((double)((float)this.method_11016().method_10263() + 0.5f), (double)((float)this.method_11016().method_10264() + 0.5f), (double)((float)this.method_11016().method_10260() + 0.5f));
        class_238 searchArea = new class_238((double)this.field_11867.method_10263() - 50.0, (double)this.field_11867.method_10264() - 50.0, (double)this.field_11867.method_10260() - 50.0, (double)this.field_11867.method_10263() + 50.0, (double)this.field_11867.method_10264() + 50.0, (double)this.field_11867.method_10260() + 50.0);
        boolean dragonSelected = false;
        assert (this.field_11863 != null);
        for (DragonBaseEntity dragon : this.field_11863.method_18467(DragonBaseEntity.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType && (dragon.isChained() || dragon.method_6181()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.field_11867;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.field_11867) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    private boolean canSeeInput(DragonBaseEntity dragon, class_243 target) {
        if (target != null) {
            assert (this.field_11863 != null);
            class_3965 rayTrace = this.field_11863.method_17742(new class_3959(dragon.getHeadPosition(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)dragon));
            double distance = dragon.getHeadPosition().method_1022(rayTrace.method_17784());
            return distance < (double)(10.0f + dragon.method_17681() * 2.0f);
        }
        return false;
    }

    private class_2680 getDeactivatedState() {
        return (class_2680)DragonForgeInputBlock.getBlockByType(this.getDragonType()).method_9564().method_11657((class_2769)DragonForgeInputBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private DragonType getDragonType() {
        DragonType dragonType;
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof DragonTypeProvider) {
            DragonTypeProvider provider = (DragonTypeProvider)class_22482;
            dragonType = provider.getDragonType();
        } else {
            dragonType = IafDragonTypes.FIRE;
        }
        return dragonType;
    }

    private boolean isActive() {
        assert (this.field_11863 != null);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_26204() instanceof DragonForgeInputBlock && (Boolean)state.method_11654((class_2769)DragonForgeInputBlock.ACTIVE) != false;
    }

    private DragonForgeBlockEntity getConnectedTileEntity(class_2338 position) {
        assert (this.field_11863 != null);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            class_2586 class_25862 = this.field_11863.method_8321(position.method_10093(facing));
            if (!(class_25862 instanceof DragonForgeBlockEntity)) continue;
            DragonForgeBlockEntity forge = (DragonForgeBlockEntity)class_25862;
            return forge;
        }
        return null;
    }
}

