/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.entity.PixieEntity;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHouseS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarS2CPayload;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.ServerHelper;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

public class JarBlockEntity
extends class_2586 {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    private final Random rand;
    public boolean hasPixie;
    public boolean prevHasProduced;
    public boolean hasProduced;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public class_2371<class_1799> pixieItems = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    public float rotationYaw;
    public float prevRotationYaw;

    public JarBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)IafBlockEntities.PIXIE_JAR.get(), pos, state);
        this.rand = new Random();
        this.hasPixie = true;
    }

    public JarBlockEntity(class_2338 pos, class_2680 state, boolean empty) {
        super((class_2591)IafBlockEntities.PIXIE_JAR.get(), pos, state);
        this.rand = new Random();
        this.hasPixie = !empty;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, JarBlockEntity entityJar) {
        ++entityJar.ticksExisted;
        if (level.field_9236 && entityJar.hasPixie) {
            level.method_8406((class_2394)IafParticles.PIXIE_DUST.get(), (double)((float)pos.method_10263() + 0.5f) + (double)(entityJar.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)pos.method_10264() + (double)(entityJar.rand.nextFloat() * 0.6f), (double)((float)pos.method_10260() + 0.5f) + (double)(entityJar.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)PixieEntity.PARTICLE_RGB[entityJar.pixieType][0], (double)PixieEntity.PARTICLE_RGB[entityJar.pixieType][1], (double)PixieEntity.PARTICLE_RGB[entityJar.pixieType][2]);
        }
        if (entityJar.ticksExisted % 24000 == 0 && !entityJar.hasProduced && entityJar.hasPixie) {
            entityJar.hasProduced = true;
            if (!level.field_9236) {
                ServerHelper.sendToAll((class_8710)new UpdatePixieJarS2CPayload(pos, true));
            }
        }
        if (entityJar.hasPixie && entityJar.hasProduced != entityJar.prevHasProduced && entityJar.ticksExisted > 5) {
            if (!level.field_9236) {
                ServerHelper.sendToAll((class_8710)new UpdatePixieJarS2CPayload(pos, entityJar.hasProduced));
            } else {
                level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (class_3414)IafSounds.PIXIE_HURT.get(), class_3419.field_15245, 1.0f, 1.0f, false);
            }
        }
        entityJar.prevRotationYaw = entityJar.rotationYaw;
        if (entityJar.rand.nextInt(30) == 0) {
            entityJar.rotationYaw = entityJar.rand.nextFloat() * 360.0f - 180.0f;
        }
        if (entityJar.hasPixie && entityJar.ticksExisted % 40 == 0 && entityJar.rand.nextInt(6) == 0 && level.field_9236) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (class_3414)IafSounds.PIXIE_IDLE.get(), class_3419.field_15245, 1.0f, 1.0f, false);
        }
        entityJar.prevHasProduced = entityJar.hasProduced;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("HasPixie", this.hasPixie);
        nbt.method_10569("PixieType", this.pixieType);
        nbt.method_10556("HasProduced", this.hasProduced);
        nbt.method_10556("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            nbt.method_25927("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        nbt.method_10569("TicksExisted", this.ticksExisted);
        class_1262.method_5426((class_2487)nbt, this.pixieItems, (class_7225.class_7874)registryLookup);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.hasPixie = nbt.method_10577("HasPixie");
        this.pixieType = nbt.method_10550("PixieType");
        this.hasProduced = nbt.method_10577("HasProduced");
        this.ticksExisted = nbt.method_10550("TicksExisted");
        this.tamedPixie = nbt.method_10577("TamedPixie");
        if (nbt.method_25928("PixieOwnerUUID")) {
            this.pixieOwnerUUID = nbt.method_25926("PixieOwnerUUID");
        }
        this.pixieItems = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.pixieItems, (class_7225.class_7874)registryLookup);
    }

    public void releasePixie() {
        PixieEntity pixie = new PixieEntity((class_1299<? extends PixieEntity>)((class_1299)IafEntities.PIXIE.get()), this.field_11863);
        pixie.method_5641((float)this.field_11867.method_10263() + 0.5f, (float)this.field_11867.method_10264() + 1.0f, (float)this.field_11867.method_10260() + 0.5f, new Random().nextInt(360), 0.0f);
        pixie.method_6122(class_1268.field_5808, (class_1799)this.pixieItems.getFirst());
        pixie.setColor(this.pixieType);
        pixie.ticksUntilHouseAI = 500;
        pixie.method_6173(this.tamedPixie, false);
        pixie.method_6174(this.pixieOwnerUUID);
        assert (this.field_11863 != null);
        this.field_11863.method_8649((class_1297)pixie);
        this.hasPixie = false;
        this.pixieType = 0;
        if (!this.field_11863.field_9236) {
            ServerHelper.sendToAll((class_8710)new UpdatePixieHouseS2CPayload(this.field_11867, false, 0));
        }
    }
}

