/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.item.block.JarBlock;
import com.iafenvoy.iceandfire.item.block.entity.JarBlockEntity;
import com.iafenvoy.iceandfire.render.entity.PixieEntityRenderer;
import com.iafenvoy.iceandfire.render.model.PixieModel;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class JarBlockEntityRenderer<T extends JarBlockEntity>
implements class_827<T> {
    public static final class_1921 TEXTURE_0 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_0, (boolean)false);
    public static final class_1921 TEXTURE_1 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_1, (boolean)false);
    public static final class_1921 TEXTURE_2 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_2, (boolean)false);
    public static final class_1921 TEXTURE_3 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_3, (boolean)false);
    public static final class_1921 TEXTURE_4 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_4, (boolean)false);
    public static final class_1921 TEXTURE_5 = class_1921.method_24293((class_2960)PixieEntityRenderer.TEXTURE_5, (boolean)false);
    public static final class_1921 TEXTURE_0_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_0);
    public static final class_1921 TEXTURE_1_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_1);
    public static final class_1921 TEXTURE_2_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_2);
    public static final class_1921 TEXTURE_3_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_3);
    public static final class_1921 TEXTURE_4_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_4);
    public static final class_1921 TEXTURE_5_GLO = class_1921.method_23026((class_2960)PixieEntityRenderer.TEXTURE_5);
    private static final Supplier<PixieModel> MODEL_PIXIE = PixieModel::new;

    public JarBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T entity, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int meta = 0;
        boolean hasPixie = false;
        if (entity.method_10997() != null) {
            class_2248 class_22482 = entity.method_11010().method_26204();
            if (class_22482 instanceof JarBlock) {
                JarBlock jar = (JarBlock)class_22482;
                meta = jar.getPixieType();
                hasPixie = !jar.isEmpty();
            } else {
                meta = ((JarBlockEntity)((Object)entity)).pixieType;
                hasPixie = ((JarBlockEntity)((Object)entity)).hasPixie;
            }
        }
        if (hasPixie) {
            matrixStackIn.method_22903();
            matrixStackIn.method_46416(0.5f, 1.501f, 0.5f);
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            matrixStackIn.method_22903();
            class_1921 type = switch (meta) {
                case 1 -> TEXTURE_1;
                case 2 -> TEXTURE_2;
                case 3 -> TEXTURE_3;
                case 4 -> TEXTURE_4;
                default -> TEXTURE_0;
            };
            class_1921 typeGlow = switch (meta) {
                case 1 -> TEXTURE_1_GLO;
                case 2 -> TEXTURE_2_GLO;
                case 3 -> TEXTURE_3_GLO;
                case 4 -> TEXTURE_4_GLO;
                default -> TEXTURE_0_GLO;
            };
            class_4588 buffer = bufferIn.getBuffer(type);
            if (entity.method_10997() != null) {
                if (((JarBlockEntity)((Object)entity)).hasProduced) {
                    matrixStackIn.method_46416(0.0f, 0.9f, 0.0f);
                } else {
                    matrixStackIn.method_46416(0.0f, 0.6f, 0.0f);
                }
                matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(this.interpolateRotation(((JarBlockEntity)((Object)entity)).prevRotationYaw, ((JarBlockEntity)((Object)entity)).rotationYaw, partialTicks)));
                matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
                PixieModel model = MODEL_PIXIE.get();
                model.animateInJar(((JarBlockEntity)((Object)entity)).hasProduced, (JarBlockEntity)((Object)entity), 0.0f);
                model.method_2828(matrixStackIn, buffer, combinedLightIn, combinedOverlayIn, -1);
                model.method_2828(matrixStackIn, bufferIn.getBuffer(typeGlow), combinedLightIn, combinedOverlayIn, -1);
            }
            matrixStackIn.method_22909();
            matrixStackIn.method_22909();
        }
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }
}

