/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.LightningDragonEntity;
import com.iafenvoy.iceandfire.render.entity.DragonBaseEntityRenderer;
import com.iafenvoy.iceandfire.render.misc.LightningBoltData;
import com.iafenvoy.iceandfire.render.misc.LightningRenderer;
import com.iafenvoy.uranus.client.model.TabulaModel;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;

public class LightningDragonEntityRenderer
extends DragonBaseEntityRenderer<LightningDragonEntity> {
    private final LightningRenderer lightningRenderer = new LightningRenderer();

    public LightningDragonEntityRenderer(class_5617.class_5618 context, TabulaModel<LightningDragonEntity> modelSupplier) {
        super(context, modelSupplier);
    }

    private static float getBoundedScale(float scale) {
        return 0.5f + scale * 1.5f;
    }

    public boolean shouldRender(LightningDragonEntity livingEntityIn, class_4604 camera, double camX, double camY, double camZ) {
        if (super.method_3933((class_1297)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasLightningTarget()) {
            class_243 head = livingEntityIn.getHeadPosition();
            class_243 target = new class_243((double)livingEntityIn.getLightningTargetX(), (double)livingEntityIn.getLightningTargetY(), (double)livingEntityIn.getLightningTargetZ());
            return camera.method_23093(new class_238(head.field_1352, head.field_1351, head.field_1350, target.field_1352, target.field_1351, target.field_1350));
        }
        return false;
    }

    public void render(LightningDragonEntity entityIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        super.method_4054((class_1309)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.method_22903();
        if (entityIn.hasLightningTarget()) {
            class_310 client = class_310.method_1551();
            assert (client.field_1724 != null);
            double dist = client.field_1724.method_5739((class_1297)entityIn);
            if (dist <= (double)Math.max(256.0f, (float)((Integer)client.field_1690.method_42503().method_41753()).intValue() * 16.0f)) {
                class_243 Vector3d1 = entityIn.getHeadPosition();
                class_243 Vector3d = new class_243((double)entityIn.getLightningTargetX(), (double)entityIn.getLightningTargetY(), (double)entityIn.getLightningTargetZ());
                float energyScale = 0.4f * entityIn.method_17825();
                LightningBoltData bolt = new LightningBoltData(LightningBoltData.BoltRenderInfo.ELECTRICITY, Vector3d1, Vector3d, 15).size(0.05f * LightningDragonEntityRenderer.getBoundedScale(energyScale)).lifespan(4).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
                this.lightningRenderer.update(null, bolt, partialTicks);
                matrixStackIn.method_22904(-entityIn.method_23317(), -entityIn.method_23318(), -entityIn.method_23321());
                this.lightningRenderer.render(partialTicks, matrixStackIn, bufferIn);
            }
        }
        matrixStackIn.method_22909();
    }
}

