/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.feature;

import com.iafenvoy.iceandfire.entity.HydraEntity;
import com.iafenvoy.iceandfire.render.entity.HydraEntityRenderer;
import com.iafenvoy.iceandfire.render.model.HydraBodyModel;
import com.iafenvoy.iceandfire.render.model.HydraHeadModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class HydraHeadFeatureRenderer
extends class_3887<HydraEntity, HydraBodyModel> {
    public static final class_2960 TEXTURE_STONE = class_2960.method_60655((String)"iceandfire", (String)"textures/entity/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private static final HydraHeadModel[] modelArr = new HydraHeadModel[9];
    private final HydraEntityRenderer renderer;

    public HydraHeadFeatureRenderer(HydraEntityRenderer renderer) {
        super((class_3883)renderer);
        this.renderer = renderer;
    }

    public static void renderHydraHeads(HydraBodyModel model, boolean stone, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, HydraEntity hydra, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.method_22903();
        int heads = hydra.getHeadCount();
        HydraHeadFeatureRenderer.translateToBody(model, matrixStackIn);
        class_1921 type = class_1921.method_23576((class_2960)(stone ? TEXTURE_STONE : HydraHeadFeatureRenderer.getHeadTexture(hydra)));
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.method_22903();
            float bodyWidth = 0.5f;
            matrixStackIn.method_46416(TRANSLATE[heads - 1][head - 1] * bodyWidth, 0.0f, 0.0f);
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(ROTATE[heads - 1][head - 1]));
            modelArr[head - 1].setAngles(hydra, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            modelArr[head - 1].method_2828(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, class_922.method_23622((class_1309)hydra, (float)0.0f), -1);
            matrixStackIn.method_22909();
        }
        matrixStackIn.method_22909();
    }

    public static class_2960 getHeadTexture(HydraEntity gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> HydraEntityRenderer.TEXUTURE_1;
            case 2 -> HydraEntityRenderer.TEXUTURE_2;
            default -> HydraEntityRenderer.TEXUTURE_0;
        };
    }

    protected static void translateToBody(HydraBodyModel model, class_4587 stack) {
        HydraHeadFeatureRenderer.postRender(model.BodyUpper, stack);
    }

    protected static void postRender(AdvancedModelBox renderer, class_4587 matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f) {
                matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            }
        } else {
            matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40718.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40716.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40714.rotation(renderer.rotateAngleX));
            }
        }
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, HydraEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.method_5767()) {
            return;
        }
        HydraHeadFeatureRenderer.renderHydraHeads((HydraBodyModel)this.renderer.method_4038(), false, matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public class_2960 getTexture(HydraEntity gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> HydraEntityRenderer.TEXUTURE_1;
            case 2 -> HydraEntityRenderer.TEXUTURE_2;
            default -> HydraEntityRenderer.TEXUTURE_0;
        };
    }

    static {
        for (int i = 0; i < modelArr.length; ++i) {
            HydraHeadFeatureRenderer.modelArr[i] = new HydraHeadModel(i);
        }
    }
}

